/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.tree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.tree.ArchiveFileTree;

public final class TarFileTree
extends ArchiveFileTree<TarFile, TarArchiveEntry> {
    private final Path tempFile;
    private final Thread shutdownHook;

    public static TarFileTree open(Path file) throws IOException {
        String fileName = file.getFileName().toString();
        if (fileName.endsWith(".tar.gz") || fileName.endsWith(".tgz")) {
            TarFile tarFile;
            Path tempFile = Files.createTempFile("hmcl-", ".tar", new FileAttribute[0]);
            try (GZIPInputStream input = new GZIPInputStream(Files.newInputStream(file, new OpenOption[0]));
                 OutputStream output = Files.newOutputStream(tempFile, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                IOUtils.copyTo(input, output);
                tarFile = new TarFile(tempFile.toFile());
            }
            catch (Throwable e) {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Throwable e2) {
                    e.addSuppressed(e2);
                }
                throw e;
            }
            return new TarFileTree(tarFile, tempFile);
        }
        return new TarFileTree(new TarFile(file), null);
    }

    public TarFileTree(TarFile file, Path tempFile) throws IOException {
        super(file);
        this.tempFile = tempFile;
        try {
            for (TarArchiveEntry entry : file.getEntries()) {
                this.addEntry(entry);
            }
        }
        catch (Throwable e) {
            try {
                file.close();
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            if (tempFile != null) {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Throwable e2) {
                    e.addSuppressed(e2);
                }
            }
            throw e;
        }
        if (tempFile != null) {
            this.shutdownHook = new Thread(() -> {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else {
            this.shutdownHook = null;
        }
    }

    @Override
    public InputStream getInputStream(TarArchiveEntry entry) throws IOException {
        return ((TarFile)this.file).getInputStream(entry);
    }

    @Override
    public boolean isLink(TarArchiveEntry entry) {
        return entry.isSymbolicLink();
    }

    @Override
    public String getLink(TarArchiveEntry entry) throws IOException {
        return entry.getLinkName();
    }

    @Override
    public boolean isExecutable(TarArchiveEntry entry) {
        return entry.isFile() && (entry.getMode() & 0x40) != 0;
    }

    @Override
    public void close() throws IOException {
        try {
            ((TarFile)this.file).close();
        }
        finally {
            if (this.tempFile != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                Files.deleteIfExists(this.tempFile);
            }
        }
    }
}

