/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.upgrade;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.Main;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SwingUtils;
import org.jackhuang.hmcl.ui.UpgradeDialog;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.upgrade.ExecutableHeaderHelper;
import org.jackhuang.hmcl.upgrade.HMCLDownloadTask;
import org.jackhuang.hmcl.upgrade.IntegrityChecker;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class UpdateHandler {
    private UpdateHandler() {
    }

    public static boolean processArguments(String[] args) {
        UpdateHandler.breakForceUpdateFeature();
        if (UpdateHandler.isNestedApplication()) {
            try {
                UpdateHandler.performMigration();
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to perform migration", e);
                SwingUtils.showErrorDialog(I18n.i18n("fatal.apply_update_failure", "https://hmcl.huangyuhui.net") + "\n" + StringUtils.getStackTrace(e));
            }
            return true;
        }
        if (args.length == 2 && args[0].equals("--apply-to")) {
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && !OperatingSystem.isWindows7OrLater()) {
                SwingUtils.showErrorDialog(I18n.i18n("fatal.apply_update_need_win7", "https://hmcl.huangyuhui.net"));
                return true;
            }
            try {
                UpdateHandler.applyUpdate(Paths.get(args[1], new String[0]));
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to apply update", e);
                SwingUtils.showErrorDialog(I18n.i18n("fatal.apply_update_failure", "https://hmcl.huangyuhui.net") + "\n" + StringUtils.getStackTrace(e));
            }
            return true;
        }
        if (UpdateHandler.isFirstLaunchAfterUpgrade()) {
            SwingUtils.showInfoDialog(I18n.i18n("fatal.migration_requires_manual_reboot"));
            return true;
        }
        return false;
    }

    public static void updateFrom(RemoteVersion version) {
        FXUtils.checkFxUserThread();
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && !OperatingSystem.isWindows7OrLater()) {
            Controllers.dialog(I18n.i18n("fatal.apply_update_need_win7", "https://hmcl.huangyuhui.net"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            return;
        }
        Controllers.dialog((Region)new UpgradeDialog(version, () -> {
            Path downloaded;
            try {
                downloaded = Files.createTempFile("hmcl-update-", ".jar", new FileAttribute[0]);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to create temp file", e);
                return;
            }
            HMCLDownloadTask task = new HMCLDownloadTask(version, downloaded);
            TaskExecutor executor = task.executor(false);
            Controllers.taskDialog(executor, I18n.i18n("message.downloading"), TaskCancellationAction.NORMAL);
            executor.start();
            Lang.thread(() -> {
                boolean success = executor.test();
                if (success) {
                    try {
                        if (!IntegrityChecker.isSelfVerified() && !IntegrityChecker.DISABLE_SELF_INTEGRITY_CHECK) {
                            throw new IOException("Current JAR is not verified");
                        }
                        UpdateHandler.requestUpdate(downloaded, UpdateHandler.getCurrentLocation());
                        Main.exit(0);
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to update to " + version, e);
                        Platform.runLater(() -> Controllers.dialog(StringUtils.getStackTrace(e), I18n.i18n("update.failed"), MessageDialogPane.MessageType.ERROR));
                    }
                } else {
                    Exception e = executor.getException();
                    Logger.LOG.warning("Failed to update to " + version, e);
                    if (e instanceof CancellationException) {
                        Platform.runLater(() -> Controllers.showToast(I18n.i18n("message.cancelled")));
                    } else {
                        Platform.runLater(() -> Controllers.dialog(e.toString(), I18n.i18n("update.failed"), MessageDialogPane.MessageType.ERROR));
                    }
                }
            });
        }));
    }

    private static void applyUpdate(Path target) throws IOException {
        Logger.LOG.info("Applying update to " + target);
        Path self = UpdateHandler.getCurrentLocation();
        if (!IntegrityChecker.DISABLE_SELF_INTEGRITY_CHECK && !IntegrityChecker.isSelfVerified()) {
            throw new IOException("Self verification failed");
        }
        ExecutableHeaderHelper.copyWithHeader(self, target);
        Optional<Path> newFilename = UpdateHandler.tryRename(target, Metadata.VERSION);
        if (newFilename.isPresent()) {
            Logger.LOG.info("Move " + target + " to " + newFilename.get());
            try {
                Files.move(target, newFilename.get(), new CopyOption[0]);
                target = newFilename.get();
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to move target", e);
            }
        }
        UpdateHandler.startJava(target, new String[0]);
    }

    private static void requestUpdate(Path updateTo, Path self) throws IOException {
        if (!IntegrityChecker.DISABLE_SELF_INTEGRITY_CHECK) {
            IntegrityChecker.verifyJar(updateTo);
        }
        UpdateHandler.startJava(updateTo, "--apply-to", self.toString());
    }

    private static void startJava(Path jar, String ... appArgs) throws IOException {
        ArrayList<String> commandline = new ArrayList<String>();
        commandline.add(JavaRuntime.getDefault().getBinary().toString());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String) || !((String)key).startsWith("hmcl.")) continue;
            commandline.add("-D" + key + "=" + entry.getValue());
        }
        commandline.add("-jar");
        commandline.add(jar.toAbsolutePath().toString());
        commandline.addAll(Arrays.asList(appArgs));
        Logger.LOG.info("Starting process: " + commandline);
        new ProcessBuilder(commandline).directory(Paths.get("", new String[0]).toAbsolutePath().toFile()).inheritIO().start();
    }

    private static Optional<Path> tryRename(Path path, String newVersion) {
        String newFilename;
        String filename = path.getFileName().toString();
        Matcher matcher = Pattern.compile("^(?<prefix>[hH][mM][cC][lL][.-])(?<version>\\d+(?:\\.\\d+)*)(?<suffix>\\.[^.]+)$").matcher(filename);
        if (matcher.find() && !(newFilename = matcher.group("prefix") + newVersion + matcher.group("suffix")).equals(filename)) {
            return Optional.of(path.resolveSibling(newFilename));
        }
        return Optional.empty();
    }

    private static Path getCurrentLocation() throws IOException {
        Path path = JarUtils.thisJarPath();
        if (path == null) {
            throw new IOException("Failed to find current HMCL location");
        }
        return path;
    }

    private static void performMigration() throws IOException {
        Logger.LOG.info("Migrating from old versions");
        Path location = UpdateHandler.getParentApplicationLocation().orElseThrow(() -> new IOException("Failed to get parent application location"));
        UpdateHandler.requestUpdate(UpdateHandler.getCurrentLocation(), location);
    }

    private static boolean isNestedApplication() {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement element = stacktrace[i];
            if (!Main.class.getName().equals(element.getClassName()) || !"main".equals(element.getMethodName())) continue;
            return i + 1 != stacktrace.length;
        }
        return false;
    }

    private static Optional<Path> getParentApplicationLocation() {
        Path path;
        String command = System.getProperty("sun.java.command");
        if (command != null && Files.isRegularFile(path = Paths.get(command, new String[0]), new LinkOption[0])) {
            return Optional.of(path.toAbsolutePath());
        }
        return Optional.empty();
    }

    private static boolean isFirstLaunchAfterUpgrade() {
        Path updated;
        Path currentPath = JarUtils.thisJarPath();
        return currentPath != null && currentPath.equals((updated = Metadata.HMCL_DIRECTORY.resolve("HMCL-" + Metadata.VERSION + ".jar")).toAbsolutePath());
    }

    private static void breakForceUpdateFeature() {
        Path hmclVersionJson = Metadata.HMCL_DIRECTORY.resolve("hmclver.json");
        if (Files.isRegularFile(hmclVersionJson, new LinkOption[0])) {
            try {
                Map content = new Gson().fromJson(FileUtils.readText(hmclVersionJson), Map.class);
                Object ver = content.get("ver");
                if (ver instanceof String && ((String)ver).startsWith("3.")) {
                    Files.delete(hmclVersionJson);
                    Logger.LOG.info("Successfully broke the force update feature");
                }
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to break the force update feature", e);
            }
            catch (JsonParseException e) {
                hmclVersionJson.toFile().delete();
            }
        }
    }
}

