/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.upgrade;

import java.io.ByteArrayInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.JarOutputStream;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.util.Pack200Utils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.tukaani.xz.XZInputStream;

class HMCLDownloadTask
extends FileDownloadTask {
    private RemoteVersion.Type archiveFormat;

    public HMCLDownloadTask(RemoteVersion version, Path target) {
        super(NetworkUtils.toURL(version.getUrl()), target.toFile(), version.getIntegrityCheck());
        this.archiveFormat = version.getType();
    }

    @Override
    public void execute() throws Exception {
        super.execute();
        try {
            Path target = this.getFile().toPath();
            switch (this.archiveFormat) {
                case JAR: {
                    break;
                }
                case PACK_XZ: {
                    byte[] raw = Files.readAllBytes(target);
                    try (XZInputStream in = new XZInputStream(new ByteArrayInputStream(raw));
                         JarOutputStream out = new JarOutputStream(Files.newOutputStream(target, new OpenOption[0]));){
                        Pack200Utils.unpack(in, out);
                        break;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown format: " + (Object)((Object)this.archiveFormat));
                }
            }
        }
        catch (Throwable e) {
            this.getFile().delete();
            throw e;
        }
    }
}

