/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.File;
import java.io.IOException;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.DialogPane;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public class VersionIconDialog
extends DialogPane {
    private final Profile profile;
    private final String versionId;
    private final Runnable onFinish;
    private final VersionSetting vs;

    public VersionIconDialog(Profile profile, String versionId, Runnable onFinish) {
        this.profile = profile;
        this.versionId = versionId;
        this.onFinish = onFinish;
        this.vs = profile.getRepository().getLocalVersionSettingOrCreate(versionId);
        this.setTitle(I18n.i18n("settings.icon"));
        FlowPane pane = new FlowPane();
        this.setBody(new Node[]{pane});
        pane.getChildren().setAll((Object[])new Node[]{this.createCustomIcon(), this.createIcon(VersionIconType.GRASS), this.createIcon(VersionIconType.CHEST), this.createIcon(VersionIconType.CHICKEN), this.createIcon(VersionIconType.COMMAND), this.createIcon(VersionIconType.OPTIFINE), this.createIcon(VersionIconType.CRAFT_TABLE), this.createIcon(VersionIconType.FABRIC), this.createIcon(VersionIconType.FORGE), this.createIcon(VersionIconType.NEO_FORGE), this.createIcon(VersionIconType.FURNACE), this.createIcon(VersionIconType.QUILT)});
    }

    private void exploreIcon() {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().add((Object)FXUtils.getImageExtensionFilter());
        File selectedFile = chooser.showOpenDialog((Window)Controllers.getStage());
        if (selectedFile != null) {
            try {
                this.profile.getRepository().setVersionIconFile(this.versionId, selectedFile);
                if (this.vs != null) {
                    this.vs.setVersionIcon(VersionIconType.DEFAULT);
                }
                this.onAccept();
            }
            catch (IOException | IllegalArgumentException e) {
                Logger.LOG.error("Failed to set icon file: " + selectedFile, e);
            }
        }
    }

    private Node createCustomIcon() {
        Node shape = SVG.PLUS_CIRCLE_OUTLINE.createIcon((Paint)Theme.blackFill(), 32.0, 32.0);
        shape.setMouseTransparent(true);
        RipplerContainer container = new RipplerContainer(shape);
        FXUtils.setLimitWidth((Region)container, 36.0);
        FXUtils.setLimitHeight((Region)container, 36.0);
        FXUtils.onClicked((Node)container, this::exploreIcon);
        return container;
    }

    private Node createIcon(VersionIconType type) {
        ImageView imageView = new ImageView(type.getIcon());
        imageView.setMouseTransparent(true);
        RipplerContainer container = new RipplerContainer((Node)imageView);
        FXUtils.setLimitWidth((Region)container, 36.0);
        FXUtils.setLimitHeight((Region)container, 36.0);
        FXUtils.onClicked((Node)container, () -> {
            if (this.vs != null) {
                this.vs.setVersionIcon(type);
                this.onAccept();
            }
        });
        return container;
    }

    @Override
    protected void onAccept() {
        this.profile.getRepository().onVersionIconChanged.fireEvent(new Event((Object)this));
        this.onFinish.run();
        super.onAccept();
    }
}

