/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import java.io.File;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.event.RefreshedVersionsEvent;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.account.AccountAdvancedListItem;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.download.ModpackInstallWizardProvider;
import org.jackhuang.hmcl.ui.main.MainPage;
import org.jackhuang.hmcl.ui.nbt.NBTEditorPage;
import org.jackhuang.hmcl.ui.nbt.NBTHelper;
import org.jackhuang.hmcl.ui.versions.GameAdvancedListItem;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public class RootPage
extends DecoratorAnimatedPage
implements DecoratorPage {
    private MainPage mainPage = null;
    private boolean checkedModpack = false;

    public RootPage() {
        EventBus.EVENT_BUS.channel(RefreshedVersionsEvent.class).register(event -> this.onRefreshedVersions((HMCLGameRepository)event.getSource()));
        Profile profile = Profiles.getSelectedProfile();
        if (profile != null && profile.getRepository().isLoaded()) {
            this.onRefreshedVersions(((Profile)Profiles.selectedProfileProperty().get()).getRepository());
        }
        this.getStyleClass().remove((Object)"gray-background");
        this.getLeft().getStyleClass().add((Object)"gray-background");
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.getMainPage().stateProperty();
    }

    protected Skin createDefaultSkin() {
        return new Skin(this);
    }

    public MainPage getMainPage() {
        if (this.mainPage == null) {
            MainPage mainPage = new MainPage();
            FXUtils.applyDragListener((Node)mainPage, file -> ModpackHelper.isFileModpackByExtension(file) || NBTHelper.isNBTFileByExtension(file), modpacks -> {
                File file = (File)modpacks.get(0);
                if (ModpackHelper.isFileModpackByExtension(file)) {
                    Controllers.getDecorator().startWizard(new ModpackInstallWizardProvider(Profiles.getSelectedProfile(), file), I18n.i18n("install.modpack"));
                } else if (NBTHelper.isNBTFileByExtension(file)) {
                    try {
                        Controllers.navigate((Node)new NBTEditorPage(file));
                    }
                    catch (Throwable e) {
                        Logger.LOG.warning("Fail to open nbt file", e);
                        Controllers.dialog(I18n.i18n("nbt.open.failed") + "\n\n" + StringUtils.getStackTrace(e), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                    }
                }
            });
            FXUtils.onChangeAndOperate(Profiles.selectedVersionProperty(), mainPage::setCurrentGame);
            mainPage.showUpdateProperty().bind((ObservableValue)UpdateChecker.outdatedProperty());
            mainPage.latestVersionProperty().bind(UpdateChecker.latestVersionProperty());
            Profiles.registerVersionsListener(profile -> {
                HMCLGameRepository repository = profile.getRepository();
                List children = repository.getVersions().parallelStream().filter(version -> !version.isHidden()).sorted(Comparator.comparing(version -> Lang.requireNonNullElse(version.getReleaseTime(), Instant.EPOCH)).thenComparing(version -> VersionNumber.asVersion(repository.getGameVersion((Version)version).orElse(version.getId())))).collect(Collectors.toList());
                FXUtils.runInFX(() -> {
                    if (profile == Profiles.getSelectedProfile()) {
                        mainPage.initVersions((Profile)profile, children);
                    }
                });
            });
            this.mainPage = mainPage;
        }
        return this.mainPage;
    }

    private void onRefreshedVersions(HMCLGameRepository repository) {
        FXUtils.runInFX(() -> {
            if (!this.checkedModpack) {
                File modpackFile;
                this.checkedModpack = true;
                if (repository.getVersionCount() == 0 && (modpackFile = new File("modpack.zip").getAbsoluteFile()).exists()) {
                    Task.supplyAsync(() -> CompressingUtils.findSuitableEncoding(modpackFile.toPath())).thenApplyAsync(encoding -> ModpackHelper.readModpackManifest(modpackFile.toPath(), encoding)).thenApplyAsync(modpack -> ModpackHelper.getInstallTask(repository.getProfile(), modpackFile, modpack.getName(), modpack).executor()).thenAcceptAsync(Schedulers.javafx(), executor -> {
                        Controllers.taskDialog(executor, I18n.i18n("modpack.installing"), TaskCancellationAction.NO_CANCEL);
                        executor.start();
                    }).start();
                }
            }
        });
    }

    private static class Skin
    extends DecoratorAnimatedPage.DecoratorAnimatedPageSkin<RootPage> {
        protected Skin(RootPage control) {
            super(control);
            AccountAdvancedListItem accountListItem = new AccountAdvancedListItem();
            accountListItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.navigate((Node)Controllers.getAccountListPage())));
            accountListItem.accountProperty().bind(Accounts.selectedAccountProperty());
            GameAdvancedListItem gameListItem = new GameAdvancedListItem();
            gameListItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> {
                Profile profile = Profiles.getSelectedProfile();
                String version = Profiles.getSelectedVersion();
                if (version == null) {
                    Controllers.navigate((Node)Controllers.getGameListPage());
                } else {
                    Versions.modifyGameSettings(profile, version);
                }
            }));
            AdvancedListItem gameItem = new AdvancedListItem();
            gameItem.setLeftGraphic(VersionPage.wrap(SVG.VIEW_LIST));
            gameItem.setActionButtonVisible(false);
            gameItem.setTitle(I18n.i18n("version.manage"));
            gameItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.navigate((Node)Controllers.getGameListPage())));
            AdvancedListItem downloadItem = new AdvancedListItem();
            downloadItem.setLeftGraphic(VersionPage.wrap(SVG.DOWNLOAD_OUTLINE));
            downloadItem.setActionButtonVisible(false);
            downloadItem.setTitle(I18n.i18n("download"));
            downloadItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.navigate((Node)Controllers.getDownloadPage())));
            FXUtils.installFastTooltip((Node)downloadItem, I18n.i18n("download.hint"));
            AdvancedListItem launcherSettingsItem = new AdvancedListItem();
            launcherSettingsItem.setLeftGraphic(VersionPage.wrap(SVG.GEAR_OUTLINE));
            launcherSettingsItem.setActionButtonVisible(false);
            launcherSettingsItem.setTitle(I18n.i18n("settings"));
            launcherSettingsItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.navigate((Node)Controllers.getSettingsPage())));
            AdvancedListItem chatItem = new AdvancedListItem();
            chatItem.setLeftGraphic(VersionPage.wrap(SVG.CHAT));
            chatItem.setActionButtonVisible(false);
            chatItem.setTitle(I18n.i18n("chat"));
            chatItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> FXUtils.openLink("https://docs.hmcl.net/groups.html")));
            AdvancedListBox sideBar = new AdvancedListBox().startCategory(I18n.i18n("account").toUpperCase(Locale.ROOT)).add((Node)accountListItem).startCategory(I18n.i18n("version").toUpperCase(Locale.ROOT)).add((Node)gameListItem).add((Node)gameItem).add((Node)downloadItem).startCategory(I18n.i18n("settings.launcher.general").toUpperCase(Locale.ROOT)).add((Node)launcherSettingsItem).add((Node)chatItem);
            this.setLeft(new Node[]{sideBar});
            this.setCenter(new Node[]{((RootPage)this.getSkinnable()).getMainPage()});
        }
    }
}

