/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXTextField;
import java.net.Proxy;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.ExtendedProperties;
import org.jackhuang.hmcl.util.javafx.SafeStringConverter;

public class DownloadSettingsPage
extends StackPane {
    public DownloadSettingsPage() {
        VBox content = new VBox(10.0);
        content.setPadding(new Insets(10.0));
        content.setFillWidth(true);
        ScrollPane scrollPane = new ScrollPane((Node)content);
        FXUtils.smoothScrolling(scrollPane);
        scrollPane.setFitToWidth(true);
        this.getChildren().setAll((Object[])new Node[]{scrollPane});
        VBox downloadSource = new VBox(8.0);
        downloadSource.getStyleClass().add((Object)"card-non-transparent");
        VBox chooseWrapper = new VBox();
        chooseWrapper.setPadding(new Insets(8.0, 0.0, 8.0, 0.0));
        JFXCheckBox chkAutoChooseDownloadSource = new JFXCheckBox(I18n.i18n("settings.launcher.download_source.auto"));
        chkAutoChooseDownloadSource.selectedProperty().bindBidirectional((Property)ConfigHolder.config().autoChooseDownloadTypeProperty());
        chooseWrapper.getChildren().setAll((Object[])new Node[]{chkAutoChooseDownloadSource});
        BorderPane versionListSourcePane = new BorderPane();
        versionListSourcePane.setPadding(new Insets(0.0, 0.0, 8.0, 30.0));
        versionListSourcePane.disableProperty().bind((ObservableValue)chkAutoChooseDownloadSource.selectedProperty().not());
        Label label = new Label(I18n.i18n("settings.launcher.version_list_source"));
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
        versionListSourcePane.setLeft((Node)label);
        JFXComboBox cboVersionListSource = new JFXComboBox();
        cboVersionListSource.setConverter(FXUtils.stringConverter(key -> I18n.i18n("download.provider." + key)));
        versionListSourcePane.setRight(cboVersionListSource);
        FXUtils.setLimitWidth(cboVersionListSource, 400.0);
        cboVersionListSource.getItems().setAll(DownloadProviders.providersById.keySet());
        ExtendedProperties.selectedItemPropertyFor(cboVersionListSource).bindBidirectional((Property)ConfigHolder.config().versionListSourceProperty());
        BorderPane downloadSourcePane = new BorderPane();
        downloadSourcePane.setPadding(new Insets(0.0, 0.0, 8.0, 30.0));
        downloadSourcePane.disableProperty().bind((ObservableValue)chkAutoChooseDownloadSource.selectedProperty());
        Label label2 = new Label(I18n.i18n("settings.launcher.download_source"));
        BorderPane.setAlignment((Node)label2, (Pos)Pos.CENTER_LEFT);
        downloadSourcePane.setLeft((Node)label2);
        JFXComboBox cboDownloadSource = new JFXComboBox();
        cboDownloadSource.setConverter(FXUtils.stringConverter(key -> I18n.i18n("download.provider." + key)));
        downloadSourcePane.setRight(cboDownloadSource);
        FXUtils.setLimitWidth(cboDownloadSource, 420.0);
        cboDownloadSource.getItems().setAll(DownloadProviders.rawProviders.keySet());
        ExtendedProperties.selectedItemPropertyFor(cboDownloadSource).bindBidirectional((Property)ConfigHolder.config().downloadTypeProperty());
        downloadSource.getChildren().setAll((Object[])new Node[]{chooseWrapper, versionListSourcePane, downloadSourcePane});
        content.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("settings.launcher.download_source")), downloadSource});
        VBox downloadThreads = new VBox(16.0);
        downloadThreads.getStyleClass().add((Object)"card-non-transparent");
        JFXCheckBox chkAutoDownloadThreads = new JFXCheckBox(I18n.i18n("settings.launcher.download.threads.auto"));
        VBox.setMargin((Node)chkAutoDownloadThreads, (Insets)new Insets(8.0, 0.0, 0.0, 0.0));
        chkAutoDownloadThreads.selectedProperty().bindBidirectional((Property)ConfigHolder.config().autoDownloadThreadsProperty());
        downloadThreads.getChildren().add((Object)chkAutoDownloadThreads);
        chkAutoDownloadThreads.selectedProperty().addListener((a, b, newValue) -> {
            if (newValue.booleanValue()) {
                ConfigHolder.config().downloadThreadsProperty().set(FetchTask.DEFAULT_CONCURRENCY);
            }
        });
        HBox hbox = new HBox(8.0);
        hbox.setAlignment(Pos.CENTER);
        hbox.setPadding(new Insets(0.0, 0.0, 0.0, 30.0));
        hbox.disableProperty().bind((ObservableValue)ConfigHolder.config().autoDownloadThreadsProperty());
        Label label3 = new Label(I18n.i18n("settings.launcher.download.threads"));
        JFXSlider slider = new JFXSlider(1.0, 256.0, 64.0);
        HBox.setHgrow((Node)slider, (Priority)Priority.ALWAYS);
        JFXTextField threadsField = new JFXTextField();
        FXUtils.setLimitWidth((Region)threadsField, 60.0);
        FXUtils.bindInt(threadsField, (Property<Number>)ConfigHolder.config().downloadThreadsProperty());
        AtomicBoolean changedByTextField = new AtomicBoolean(false);
        FXUtils.onChangeAndOperate(ConfigHolder.config().downloadThreadsProperty(), value -> {
            changedByTextField.set(true);
            slider.setValue(value.intValue());
            changedByTextField.set(false);
        });
        slider.valueProperty().addListener((value, oldVal, newVal) -> {
            if (changedByTextField.get()) {
                return;
            }
            ConfigHolder.config().downloadThreadsProperty().set(((Number)value.getValue()).intValue());
        });
        hbox.getChildren().setAll((Object[])new Node[]{label3, slider, threadsField});
        downloadThreads.getChildren().add((Object)hbox);
        HintPane hintPane = new HintPane(MessageDialogPane.MessageType.INFO);
        VBox.setMargin((Node)hintPane, (Insets)new Insets(0.0, 0.0, 0.0, 30.0));
        hintPane.disableProperty().bind((ObservableValue)ConfigHolder.config().autoDownloadThreadsProperty());
        hintPane.setText(I18n.i18n("settings.launcher.download.threads.hint"));
        downloadThreads.getChildren().add((Object)hintPane);
        content.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("download")), downloadThreads});
        VBox proxyList = new VBox(10.0);
        proxyList.getStyleClass().add((Object)"card-non-transparent");
        VBox proxyPane = new VBox();
        JFXCheckBox chkDisableProxy = new JFXCheckBox(I18n.i18n("settings.launcher.proxy.disable"));
        VBox.setMargin((Node)chkDisableProxy, (Insets)new Insets(8.0, 0.0, 0.0, 0.0));
        proxyList.getChildren().add((Object)chkDisableProxy);
        ExtendedProperties.reversedSelectedPropertyFor(chkDisableProxy).bindBidirectional((Property)ConfigHolder.config().hasProxyProperty());
        proxyPane.disableProperty().bind((ObservableValue)chkDisableProxy.selectedProperty());
        proxyPane.setPadding(new Insets(0.0, 0.0, 0.0, 30.0));
        ColumnConstraints colHgrow = new ColumnConstraints();
        colHgrow.setHgrow(Priority.ALWAYS);
        HBox hBox = new HBox();
        JFXRadioButton chkProxyNone = new JFXRadioButton(I18n.i18n("settings.launcher.proxy.none"));
        JFXRadioButton chkProxyHttp = new JFXRadioButton(I18n.i18n("settings.launcher.proxy.http"));
        JFXRadioButton chkProxySocks = new JFXRadioButton(I18n.i18n("settings.launcher.proxy.socks"));
        hBox.getChildren().setAll((Object[])new Node[]{chkProxyNone, chkProxyHttp, chkProxySocks});
        proxyPane.getChildren().add((Object)hBox);
        GridPane gridPane = new GridPane();
        gridPane.setHgap(20.0);
        gridPane.setVgap(10.0);
        gridPane.setStyle("-fx-padding: 0 0 0 15;");
        gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), colHgrow});
        gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{new RowConstraints(), new RowConstraints()});
        Label host = new Label(I18n.i18n("settings.launcher.proxy.host"));
        GridPane.setRowIndex((Node)host, (Integer)1);
        GridPane.setColumnIndex((Node)host, (Integer)0);
        gridPane.getChildren().add((Object)host);
        JFXTextField txtProxyHost = new JFXTextField();
        GridPane.setRowIndex((Node)txtProxyHost, (Integer)1);
        GridPane.setColumnIndex((Node)txtProxyHost, (Integer)1);
        gridPane.getChildren().add((Object)txtProxyHost);
        FXUtils.bindString(txtProxyHost, (Property<String>)ConfigHolder.config().proxyHostProperty());
        Label port = new Label(I18n.i18n("settings.launcher.proxy.port"));
        GridPane.setRowIndex((Node)port, (Integer)2);
        GridPane.setColumnIndex((Node)port, (Integer)0);
        gridPane.getChildren().add((Object)port);
        JFXTextField txtProxyPort = new JFXTextField();
        GridPane.setRowIndex((Node)txtProxyPort, (Integer)2);
        GridPane.setColumnIndex((Node)txtProxyPort, (Integer)1);
        FXUtils.setValidateWhileTextChanged((Node)txtProxyPort, true);
        gridPane.getChildren().add((Object)txtProxyPort);
        FXUtils.bind(txtProxyPort, ConfigHolder.config().proxyPortProperty(), SafeStringConverter.fromInteger().restrict(it -> it >= 0 && it <= 65535).fallbackTo(0).asPredicate(Validator.addTo(txtProxyPort)));
        proxyPane.getChildren().add((Object)gridPane);
        GridPane authPane = new GridPane();
        VBox vBox = new VBox();
        vBox.setStyle("-fx-padding: 20 0 20 5;");
        JFXCheckBox chkProxyAuthentication = new JFXCheckBox(I18n.i18n("settings.launcher.proxy.authentication"));
        vBox.getChildren().setAll((Object[])new Node[]{chkProxyAuthentication});
        authPane.disableProperty().bind((ObservableValue)chkProxyAuthentication.selectedProperty().not());
        chkProxyAuthentication.selectedProperty().bindBidirectional((Property)ConfigHolder.config().hasProxyAuthProperty());
        proxyPane.getChildren().add((Object)vBox);
        authPane.setHgap(20.0);
        authPane.setVgap(10.0);
        authPane.setStyle("-fx-padding: 0 0 0 15;");
        authPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), colHgrow});
        authPane.getRowConstraints().setAll((Object[])new RowConstraints[]{new RowConstraints(), new RowConstraints()});
        Label username = new Label(I18n.i18n("settings.launcher.proxy.username"));
        GridPane.setRowIndex((Node)username, (Integer)0);
        GridPane.setColumnIndex((Node)username, (Integer)0);
        authPane.getChildren().add((Object)username);
        JFXTextField txtProxyUsername = new JFXTextField();
        GridPane.setRowIndex((Node)txtProxyUsername, (Integer)0);
        GridPane.setColumnIndex((Node)txtProxyUsername, (Integer)1);
        authPane.getChildren().add((Object)txtProxyUsername);
        FXUtils.bindString(txtProxyUsername, (Property<String>)ConfigHolder.config().proxyUserProperty());
        Label password = new Label(I18n.i18n("settings.launcher.proxy.password"));
        GridPane.setRowIndex((Node)password, (Integer)1);
        GridPane.setColumnIndex((Node)password, (Integer)0);
        authPane.getChildren().add((Object)password);
        JFXPasswordField txtProxyPassword = new JFXPasswordField();
        GridPane.setRowIndex((Node)txtProxyPassword, (Integer)1);
        GridPane.setColumnIndex((Node)txtProxyPassword, (Integer)1);
        authPane.getChildren().add((Object)txtProxyPassword);
        txtProxyPassword.textProperty().bindBidirectional((Property)ConfigHolder.config().proxyPassProperty());
        ToggleGroup proxyConfigurationGroup = new ToggleGroup();
        chkProxyNone.setUserData((Object)Proxy.Type.DIRECT);
        chkProxyNone.setToggleGroup(proxyConfigurationGroup);
        chkProxyHttp.setUserData((Object)Proxy.Type.HTTP);
        chkProxyHttp.setToggleGroup(proxyConfigurationGroup);
        chkProxySocks.setUserData((Object)Proxy.Type.SOCKS);
        chkProxySocks.setToggleGroup(proxyConfigurationGroup);
        ExtendedProperties.selectedItemPropertyFor(proxyConfigurationGroup, Proxy.Type.class).bindBidirectional(ConfigHolder.config().proxyTypeProperty());
        proxyPane.getChildren().add((Object)authPane);
        proxyList.getChildren().add((Object)proxyPane);
        content.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("settings.launcher.proxy")), proxyList});
    }
}

