/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.IconedTwoLineListItem;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public final class AboutPage
extends StackPane {
    public AboutPage() {
        ComponentList about = new ComponentList();
        IconedTwoLineListItem launcher = new IconedTwoLineListItem();
        launcher.setImage(FXUtils.newBuiltinImage("/assets/img/icon.png"));
        launcher.setTitle("Hello Minecraft! Launcher");
        launcher.setSubtitle(Metadata.VERSION);
        launcher.setExternalLink("https://hmcl.huangyuhui.net");
        IconedTwoLineListItem author = new IconedTwoLineListItem();
        author.setImage(FXUtils.newBuiltinImage("/assets/img/yellow_fish.png"));
        author.setTitle("huanghongxun");
        author.setSubtitle(I18n.i18n("about.author.statement"));
        author.setExternalLink("https://space.bilibili.com/1445341");
        about.getContent().setAll((Object[])new Node[]{launcher, author});
        ComponentList thanks = AboutPage.loadIconedTwoLineList("/assets/about/thanks.json");
        ComponentList deps = AboutPage.loadIconedTwoLineList("/assets/about/deps.json");
        ComponentList legal = new ComponentList();
        IconedTwoLineListItem copyright = new IconedTwoLineListItem();
        copyright.setTitle(I18n.i18n("about.copyright"));
        copyright.setSubtitle(I18n.i18n("about.copyright.statement"));
        copyright.setExternalLink("https://hmcl.huangyuhui.net/about/");
        IconedTwoLineListItem claim = new IconedTwoLineListItem();
        claim.setTitle(I18n.i18n("about.claim"));
        claim.setSubtitle(I18n.i18n("about.claim.statement"));
        claim.setExternalLink("https://docs.hmcl.net/eula/hmcl.html");
        IconedTwoLineListItem openSource = new IconedTwoLineListItem();
        openSource.setTitle(I18n.i18n("about.open_source"));
        openSource.setSubtitle(I18n.i18n("about.open_source.statement"));
        openSource.setExternalLink("https://github.com/HMCL-dev/HMCL");
        legal.getContent().setAll((Object[])new Node[]{copyright, claim, openSource});
        VBox content = new VBox(16.0);
        content.setPadding(new Insets(10.0));
        content.getChildren().setAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("about")), about, ComponentList.createComponentListTitle(I18n.i18n("about.thanks_to")), thanks, ComponentList.createComponentListTitle(I18n.i18n("about.dependency")), deps, ComponentList.createComponentListTitle(I18n.i18n("about.legal")), legal});
        ScrollPane scrollPane = new ScrollPane((Node)content);
        scrollPane.setFitToWidth(true);
        FXUtils.smoothScrolling(scrollPane);
        this.getChildren().setAll((Object[])new Node[]{scrollPane});
    }

    private static ComponentList loadIconedTwoLineList(String path) {
        ComponentList componentList = new ComponentList();
        InputStream input = FXUtils.class.getResourceAsStream(path);
        if (input == null) {
            Logger.LOG.warning("Resources not found: " + path);
            return componentList;
        }
        try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
            JsonArray array = JsonUtils.GSON.fromJson((Reader)reader, JsonArray.class);
            for (JsonElement element : array) {
                JsonObject obj = element.getAsJsonObject();
                IconedTwoLineListItem item = new IconedTwoLineListItem();
                if (obj.has("image")) {
                    String image = obj.get("image").getAsString();
                    item.setImage(image.startsWith("/") ? FXUtils.newBuiltinImage(image) : new Image(image));
                }
                if (obj.has("title")) {
                    item.setTitle(obj.get("title").getAsString());
                } else if (obj.has("titleLocalized")) {
                    item.setTitle(I18n.i18n(obj.get("titleLocalized").getAsString()));
                }
                if (obj.has("subtitle")) {
                    item.setSubtitle(obj.get("subtitle").getAsString());
                } else if (obj.has("subtitleLocalized")) {
                    item.setSubtitle(I18n.i18n(obj.get("subtitleLocalized").getAsString()));
                }
                if (obj.has("externalLink")) {
                    item.setExternalLink(obj.get("externalLink").getAsString());
                }
                componentList.getContent().add((Object)item);
            }
        }
        catch (JsonParseException | IOException e) {
            Logger.LOG.warning("Failed to load list: " + path, e);
        }
        return componentList;
    }
}

