/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.AggregatedObservableList;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;

public class TwoLineListItem
extends VBox {
    private static final String DEFAULT_STYLE_CLASS = "two-line-list-item";
    private final StringProperty title = new SimpleStringProperty((Object)this, "title");
    private final ObservableList<String> tags = FXCollections.observableArrayList();
    private final StringProperty subtitle = new SimpleStringProperty((Object)this, "subtitle");
    private final ObservableList<Node> tagLabels;
    private final AggregatedObservableList<Node> firstLineChildren;

    public TwoLineListItem(String titleString, String subtitleString) {
        this();
        this.title.set((Object)titleString);
        this.subtitle.set((Object)subtitleString);
    }

    public TwoLineListItem() {
        this.setMouseTransparent(true);
        HBox firstLine = new HBox();
        firstLine.getStyleClass().add((Object)"first-line");
        Label lblTitle = new Label();
        lblTitle.getStyleClass().add((Object)"title");
        lblTitle.textProperty().bind((ObservableValue)this.title);
        this.tagLabels = MappedObservableList.create(this.tags, tag -> {
            Label tagLabel = new Label();
            tagLabel.getStyleClass().add((Object)"tag");
            tagLabel.setText(tag);
            HBox.setMargin((Node)tagLabel, (Insets)new Insets(0.0, 8.0, 0.0, 0.0));
            return tagLabel;
        });
        this.firstLineChildren = new AggregatedObservableList();
        this.firstLineChildren.appendList((ObservableList<Node>)FXCollections.singletonObservableList((Object)lblTitle));
        this.firstLineChildren.appendList(this.tagLabels);
        Bindings.bindContent((List)firstLine.getChildren(), this.firstLineChildren.getAggregatedList());
        Label lblSubtitle = new Label();
        lblSubtitle.getStyleClass().add((Object)"subtitle");
        lblSubtitle.textProperty().bind((ObservableValue)this.subtitle);
        HBox secondLine = new HBox();
        secondLine.getChildren().setAll((Object[])new Node[]{lblSubtitle});
        this.getChildren().setAll((Object[])new Node[]{firstLine, secondLine});
        FXUtils.onChangeAndOperate(this.subtitle, subtitleString -> {
            if (subtitleString == null) {
                this.getChildren().setAll((Object[])new Node[]{firstLine});
            } else {
                this.getChildren().setAll((Object[])new Node[]{firstLine, secondLine});
            }
        });
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public ObservableList<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return this.getTitle();
    }
}

