/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.util.StringUtils;

public class IconedTwoLineListItem
extends HBox {
    private final StringProperty title = new SimpleStringProperty((Object)this, "title");
    private final ObservableList<String> tags = FXCollections.observableArrayList();
    private final StringProperty subtitle = new SimpleStringProperty((Object)this, "subtitle");
    private final StringProperty externalLink = new SimpleStringProperty((Object)this, "externalLink");
    private final ObjectProperty<Image> image = new SimpleObjectProperty((Object)this, "image");
    private final ImageView imageView = new ImageView();
    private final TwoLineListItem twoLineListItem = new TwoLineListItem();
    private JFXButton externalLinkButton;
    private final InvalidationListener observer;

    public IconedTwoLineListItem() {
        this.setAlignment(Pos.CENTER);
        this.setSpacing(16.0);
        this.imageView.imageProperty().bind(this.image);
        this.twoLineListItem.titleProperty().bind((ObservableValue)this.title);
        this.twoLineListItem.subtitleProperty().bind((ObservableValue)this.subtitle);
        HBox.setHgrow((Node)this.twoLineListItem, (Priority)Priority.ALWAYS);
        Bindings.bindContent(this.twoLineListItem.getTags(), this.tags);
        this.observer = FXUtils.observeWeak(() -> {
            this.getChildren().clear();
            if (this.image.get() != null) {
                this.getChildren().add((Object)this.imageView);
            }
            this.getChildren().add((Object)this.twoLineListItem);
            if (StringUtils.isNotBlank((String)this.externalLink.get())) {
                this.getChildren().add((Object)this.getExternalLinkButton());
            }
        }, new Observable[]{this.image, this.externalLink});
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public ObservableList<String> getTags() {
        return this.tags;
    }

    public String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public String getExternalLink() {
        return (String)this.externalLink.get();
    }

    public StringProperty externalLinkProperty() {
        return this.externalLink;
    }

    public void setExternalLink(String externalLink) {
        this.externalLink.set((Object)externalLink);
    }

    public Image getImage() {
        return (Image)this.image.get();
    }

    public ObjectProperty<Image> imageProperty() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image.set((Object)image);
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public JFXButton getExternalLinkButton() {
        if (this.externalLinkButton == null) {
            this.externalLinkButton = new JFXButton();
            this.externalLinkButton.getStyleClass().add((Object)"toggle-icon4");
            this.externalLinkButton.setGraphic(SVG.OPEN_IN_NEW.createIcon((Paint)Theme.blackFill(), -1.0, -1.0));
            this.externalLinkButton.setOnAction(e -> FXUtils.openLink((String)this.externalLink.get()));
        }
        return this.externalLinkButton;
    }
}

