/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListCell;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.text.Font;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

public class FontComboBox
extends JFXComboBox<String> {
    private boolean loaded = false;

    public FontComboBox() {
        this.setMinWidth(260.0);
        this.styleProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{"-fx-font-family: \"", this.valueProperty(), "\""}));
        this.setCellFactory(listView -> new JFXListCell<String>(){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (!empty) {
                    this.setText(item);
                    this.setGraphic(null);
                    this.setStyle("-fx-font-family: \"" + item + "\"");
                }
            }
        });
        this.itemsProperty().bind(BindingMapping.of(this.valueProperty()).map(value -> value == null ? FXCollections.emptyObservableList() : FXCollections.singletonObservableList((Object)value)));
        FXUtils.onClicked((Node)this, () -> {
            if (this.loaded) {
                return;
            }
            this.itemsProperty().unbind();
            this.setItems(FXCollections.observableList((List)Font.getFamilies()));
            this.loaded = true;
        });
    }
}

