/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextFlow;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;

public final class AnnouncementCard
extends VBox {
    public AnnouncementCard(String title, String content, Runnable onClose) {
        TextFlow body = FXUtils.segmentToTextFlow(content, Controllers::onHyperlinkAction);
        body.setLineSpacing(4.0);
        BorderPane titleBar = new BorderPane();
        titleBar.getStyleClass().add((Object)"title");
        titleBar.setLeft((Node)new Label(title));
        if (onClose != null) {
            Node hideNode = SVG.CLOSE.createIcon((Paint)Theme.blackFill(), 20.0, 20.0);
            hideNode.setOnMouseClicked(e -> onClose.run());
            hideNode.setCursor(Cursor.HAND);
            titleBar.setRight(hideNode);
        }
        this.getChildren().setAll((Object[])new Node[]{titleBar, body});
        this.setSpacing(16.0);
        this.getStyleClass().addAll((Object[])new String[]{"card", "announcement"});
    }
}

