/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Tooltip;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccount;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilAccount;
import org.jackhuang.hmcl.game.TexturesLoader;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

public class AccountAdvancedListItem
extends AdvancedListItem {
    private final Tooltip tooltip;
    private final Canvas canvas;
    private final ObjectProperty<Account> account = new SimpleObjectProperty<Account>(){

        protected void invalidated() {
            Account account = (Account)this.get();
            if (account == null) {
                AccountAdvancedListItem.this.titleProperty().unbind();
                AccountAdvancedListItem.this.subtitleProperty().unbind();
                AccountAdvancedListItem.this.tooltip.textProperty().unbind();
                AccountAdvancedListItem.this.setTitle(I18n.i18n("account.missing"));
                AccountAdvancedListItem.this.setSubtitle(I18n.i18n("account.missing.add"));
                AccountAdvancedListItem.this.tooltip.setText(I18n.i18n("account.create"));
                TexturesLoader.unbindAvatar(AccountAdvancedListItem.this.canvas);
                TexturesLoader.drawAvatar(AccountAdvancedListItem.this.canvas, TexturesLoader.getDefaultSkinImage());
            } else {
                AccountAdvancedListItem.this.titleProperty().bind(BindingMapping.of(account, Account::getCharacter));
                AccountAdvancedListItem.this.subtitleProperty().bind(AccountAdvancedListItem.accountSubtitle(account));
                AccountAdvancedListItem.this.tooltip.textProperty().bind(AccountAdvancedListItem.accountTooltip(account));
                TexturesLoader.bindAvatar(AccountAdvancedListItem.this.canvas, account);
            }
        }
    };

    public AccountAdvancedListItem() {
        this.tooltip = new Tooltip();
        FXUtils.installFastTooltip((Node)this, this.tooltip);
        this.canvas = new Canvas(32.0, 32.0);
        this.setLeftGraphic((Node)this.canvas);
        this.setActionButtonVisible(false);
        this.setOnScroll(event -> {
            Account current = (Account)this.account.get();
            if (current == null) {
                return;
            }
            ObservableList<Account> accounts = Accounts.getAccounts();
            int currentIndex = accounts.indexOf(this.account.get());
            currentIndex = event.getDeltaY() > 0.0 ? --currentIndex : ++currentIndex;
            Accounts.setSelectedAccount((Account)accounts.get((currentIndex + accounts.size()) % accounts.size()));
        });
    }

    public ObjectProperty<Account> accountProperty() {
        return this.account;
    }

    private static ObservableValue<String> accountSubtitle(Account account) {
        if (account instanceof AuthlibInjectorAccount) {
            return BindingMapping.of(((AuthlibInjectorAccount)account).getServer(), AuthlibInjectorServer::getName);
        }
        return Bindings.createStringBinding(() -> Accounts.getLocalizedLoginTypeName(Accounts.getAccountFactory(account)), (Observable[])new Observable[0]);
    }

    private static ObservableValue<String> accountTooltip(Account account) {
        if (account instanceof AuthlibInjectorAccount) {
            AuthlibInjectorServer server = ((AuthlibInjectorAccount)account).getServer();
            return Bindings.format((String)"%s (%s) (%s)", (Object[])new Object[]{BindingMapping.of(account, Account::getCharacter), account.getUsername(), BindingMapping.of(server, AuthlibInjectorServer::getName)});
        }
        if (account instanceof YggdrasilAccount) {
            return Bindings.format((String)"%s (%s)", (Object[])new Object[]{BindingMapping.of(account, Account::getCharacter), account.getUsername()});
        }
        return BindingMapping.of(account, Account::getCharacter);
    }
}

