/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modinfo;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

@Immutable
public final class ForgeOldModMetadata {
    @SerializedName(value="modid")
    private final String modId;
    private final String name;
    private final String description;
    private final String author;
    private final String version;
    private final String logoFile;
    private final String mcversion;
    private final String url;
    private final String updateUrl;
    private final String credits;
    private final String[] authorList;
    private final String[] authors;

    public ForgeOldModMetadata() {
        this("", "", "", "", "", "", "", "", "", "", new String[0], new String[0]);
    }

    public ForgeOldModMetadata(String modId, String name, String description, String author, String version, String logoFile, String mcversion, String url, String updateUrl, String credits, String[] authorList, String[] authors) {
        this.modId = modId;
        this.name = name;
        this.description = description;
        this.author = author;
        this.version = version;
        this.logoFile = logoFile;
        this.mcversion = mcversion;
        this.url = url;
        this.updateUrl = updateUrl;
        this.credits = credits;
        this.authorList = authorList;
        this.authors = authors;
    }

    public String getModId() {
        return this.modId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLogoFile() {
        return this.logoFile;
    }

    public String getGameVersion() {
        return this.mcversion;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUpdateUrl() {
        return this.updateUrl;
    }

    public String getCredits() {
        return this.credits;
    }

    public String[] getAuthorList() {
        return this.authorList;
    }

    public String[] getAuthors() {
        return this.authors;
    }

    public static LocalModFile fromFile(ModManager modManager, Path modFile, FileSystem fs) throws IOException, JsonParseException {
        Path mcmod = fs.getPath("mcmod.info", new String[0]);
        if (Files.notExists(mcmod, new LinkOption[0])) {
            throw new IOException("File " + modFile + " is not a Forge mod.");
        }
        List<ForgeOldModMetadata> modList = JsonUtils.GSON.fromJson(FileUtils.readText(mcmod), JsonUtils.listTypeOf(ForgeOldModMetadata.class));
        if (modList == null || modList.isEmpty()) {
            throw new IOException("Mod " + modFile + " `mcmod.info` is malformed..");
        }
        ForgeOldModMetadata metadata = modList.get(0);
        String authors = metadata.getAuthor();
        if (StringUtils.isBlank(authors) && metadata.getAuthors().length > 0) {
            authors = String.join((CharSequence)", ", metadata.getAuthors());
        }
        if (StringUtils.isBlank(authors) && metadata.getAuthorList().length > 0) {
            authors = String.join((CharSequence)", ", metadata.getAuthorList());
        }
        if (StringUtils.isBlank(authors)) {
            authors = metadata.getCredits();
        }
        return new LocalModFile(modManager, modManager.getLocalMod(metadata.getModId(), ModLoaderType.FORGE), modFile, metadata.getName(), new LocalModFile.Description(metadata.getDescription()), authors, metadata.getVersion(), metadata.getGameVersion(), StringUtils.isBlank(metadata.getUrl()) ? metadata.getUpdateUrl() : metadata.url, metadata.getLogoFile());
    }
}

