/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.curse;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jetbrains.annotations.Nullable;

@Immutable
public class CurseAddon
implements RemoteMod.IMod {
    public static final Map<Integer, RemoteMod.DependencyType> RELATION_TYPE = Lang.mapOf(Pair.pair(1, RemoteMod.DependencyType.EMBEDDED), Pair.pair(2, RemoteMod.DependencyType.OPTIONAL), Pair.pair(3, RemoteMod.DependencyType.REQUIRED), Pair.pair(4, RemoteMod.DependencyType.TOOL), Pair.pair(5, RemoteMod.DependencyType.INCOMPATIBLE), Pair.pair(6, RemoteMod.DependencyType.INCLUDE));
    private final int id;
    private final int gameId;
    private final String name;
    private final String slug;
    private final Links links;
    private final String summary;
    private final int status;
    private final int downloadCount;
    private final boolean isFeatured;
    private final int primaryCategoryId;
    private final List<Category> categories;
    private final int classId;
    private final List<Author> authors;
    private final Logo logo;
    private final int mainFileId;
    private final List<LatestFile> latestFiles;
    private final List<LatestFileIndex> latestFileIndices;
    private final Instant dateCreated;
    private final Instant dateModified;
    private final Instant dateReleased;
    private final boolean allowModDistribution;
    private final int gamePopularityRank;
    private final boolean isAvailable;
    private final int thumbsUpCount;

    public CurseAddon(int id, int gameId, String name, String slug, Links links, String summary, int status, int downloadCount, boolean isFeatured, int primaryCategoryId, List<Category> categories, int classId, List<Author> authors, Logo logo, int mainFileId, List<LatestFile> latestFiles, List<LatestFileIndex> latestFileIndices, Instant dateCreated, Instant dateModified, Instant dateReleased, boolean allowModDistribution, int gamePopularityRank, boolean isAvailable, int thumbsUpCount) {
        this.id = id;
        this.gameId = gameId;
        this.name = name;
        this.slug = slug;
        this.links = links;
        this.summary = summary;
        this.status = status;
        this.downloadCount = downloadCount;
        this.isFeatured = isFeatured;
        this.primaryCategoryId = primaryCategoryId;
        this.categories = categories;
        this.classId = classId;
        this.authors = authors;
        this.logo = logo;
        this.mainFileId = mainFileId;
        this.latestFiles = latestFiles;
        this.latestFileIndices = latestFileIndices;
        this.dateCreated = dateCreated;
        this.dateModified = dateModified;
        this.dateReleased = dateReleased;
        this.allowModDistribution = allowModDistribution;
        this.gamePopularityRank = gamePopularityRank;
        this.isAvailable = isAvailable;
        this.thumbsUpCount = thumbsUpCount;
    }

    public int getId() {
        return this.id;
    }

    public int getGameId() {
        return this.gameId;
    }

    public String getName() {
        return this.name;
    }

    public String getSlug() {
        return this.slug;
    }

    public Links getLinks() {
        return this.links;
    }

    public String getSummary() {
        return this.summary;
    }

    public int getStatus() {
        return this.status;
    }

    public int getDownloadCount() {
        return this.downloadCount;
    }

    public boolean isFeatured() {
        return this.isFeatured;
    }

    public int getPrimaryCategoryId() {
        return this.primaryCategoryId;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public int getClassId() {
        return this.classId;
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public Logo getLogo() {
        return this.logo;
    }

    public int getMainFileId() {
        return this.mainFileId;
    }

    public List<LatestFile> getLatestFiles() {
        return this.latestFiles;
    }

    public List<LatestFileIndex> getLatestFileIndices() {
        return this.latestFileIndices;
    }

    public Instant getDateCreated() {
        return this.dateCreated;
    }

    public Instant getDateModified() {
        return this.dateModified;
    }

    public Instant getDateReleased() {
        return this.dateReleased;
    }

    public boolean isAllowModDistribution() {
        return this.allowModDistribution;
    }

    public int getGamePopularityRank() {
        return this.gamePopularityRank;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public int getThumbsUpCount() {
        return this.thumbsUpCount;
    }

    @Override
    public List<RemoteMod> loadDependencies(RemoteModRepository modRepository) throws IOException {
        Set dependencies = this.latestFiles.stream().flatMap(latestFile -> latestFile.getDependencies().stream()).filter(dep -> dep.getRelationType() == 3).map(Dependency::getModId).collect(Collectors.toSet());
        ArrayList<RemoteMod> mods = new ArrayList<RemoteMod>();
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            int dependencyId = (Integer)iterator.next();
            mods.add(modRepository.getModById(Integer.toString(dependencyId)));
        }
        return mods;
    }

    @Override
    public Stream<RemoteMod.Version> loadVersions(RemoteModRepository modRepository) throws IOException {
        return modRepository.getRemoteVersionsById(Integer.toString(this.id));
    }

    public RemoteMod toMod() {
        String iconUrl = Optional.ofNullable(this.logo).map(Logo::getThumbnailUrl).orElse("");
        return new RemoteMod(this.slug, "", this.name, this.summary, this.categories.stream().map(category -> Integer.toString(category.getId())).collect(Collectors.toList()), this.links.websiteUrl, iconUrl, this);
    }

    @Immutable
    public static class Links {
        private final String websiteUrl;
        private final String wikiUrl;
        private final String issuesUrl;
        private final String sourceUrl;

        public Links(String websiteUrl, String wikiUrl, String issuesUrl, String sourceUrl) {
            this.websiteUrl = websiteUrl;
            this.wikiUrl = wikiUrl;
            this.issuesUrl = issuesUrl;
            this.sourceUrl = sourceUrl;
        }

        public String getWebsiteUrl() {
            return this.websiteUrl;
        }

        public String getWikiUrl() {
            return this.wikiUrl;
        }

        @Nullable
        public String getIssuesUrl() {
            return this.issuesUrl;
        }

        @Nullable
        public String getSourceUrl() {
            return this.sourceUrl;
        }
    }

    @Immutable
    public static class Logo {
        private final int id;
        private final int modId;
        private final String title;
        private final String description;
        private final String thumbnailUrl;
        private final String url;

        public Logo(int id, int modId, String title, String description, String thumbnailUrl, String url) {
            this.id = id;
            this.modId = modId;
            this.title = title;
            this.description = description;
            this.thumbnailUrl = thumbnailUrl;
            this.url = url;
        }

        public int getId() {
            return this.id;
        }

        public int getModId() {
            return this.modId;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public String getThumbnailUrl() {
            return this.thumbnailUrl;
        }

        public String getUrl() {
            return this.url;
        }
    }

    @Immutable
    public static class Category {
        private final int id;
        private final int gameId;
        private final String name;
        private final String slug;
        private final String url;
        private final String iconUrl;
        private final Instant dateModified;
        private final boolean isClass;
        private final int classId;
        private final int parentCategoryId;
        private final transient List<Category> subcategories;

        public Category() {
            this(0, 0, "", "", "", "", Instant.now(), false, 0, 0);
        }

        public Category(int id, int gameId, String name, String slug, String url, String iconUrl, Instant dateModified, boolean isClass, int classId, int parentCategoryId) {
            this.id = id;
            this.gameId = gameId;
            this.name = name;
            this.slug = slug;
            this.url = url;
            this.iconUrl = iconUrl;
            this.dateModified = dateModified;
            this.isClass = isClass;
            this.classId = classId;
            this.parentCategoryId = parentCategoryId;
            this.subcategories = new ArrayList<Category>();
        }

        public int getId() {
            return this.id;
        }

        public int getGameId() {
            return this.gameId;
        }

        public String getName() {
            return this.name;
        }

        public String getSlug() {
            return this.slug;
        }

        public String getUrl() {
            return this.url;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public Instant getDateModified() {
            return this.dateModified;
        }

        public boolean isClass() {
            return this.isClass;
        }

        public int getClassId() {
            return this.classId;
        }

        public int getParentCategoryId() {
            return this.parentCategoryId;
        }

        public List<Category> getSubcategories() {
            return this.subcategories;
        }

        public RemoteModRepository.Category toCategory() {
            return new RemoteModRepository.Category(this, Integer.toString(this.id), this.getSubcategories().stream().map(Category::toCategory).collect(Collectors.toList()));
        }
    }

    @Immutable
    public static class Dependency {
        private final int modId;
        private final int relationType;

        public Dependency() {
            this(0, 1);
        }

        public Dependency(int modId, int relationType) {
            this.modId = modId;
            this.relationType = relationType;
        }

        public int getModId() {
            return this.modId;
        }

        public int getRelationType() {
            return this.relationType;
        }
    }

    @Immutable
    public static class LatestFile
    implements RemoteMod.IVersion {
        private final int id;
        private final int gameId;
        private final int modId;
        private final boolean isAvailable;
        private final String displayName;
        private final String fileName;
        private final int releaseType;
        private final int fileStatus;
        private final List<LatestFileHash> hashes;
        private final Instant fileDate;
        private final int fileLength;
        private final int downloadCount;
        private final String downloadUrl;
        private final List<String> gameVersions;
        private final List<Dependency> dependencies;
        private final int alternateFileId;
        private final boolean isServerPack;
        private final long fileFingerprint;

        public LatestFile(int id, int gameId, int modId, boolean isAvailable, String displayName, String fileName, int releaseType, int fileStatus, List<LatestFileHash> hashes, Instant fileDate, int fileLength, int downloadCount, String downloadUrl, List<String> gameVersions, List<Dependency> dependencies, int alternateFileId, boolean isServerPack, long fileFingerprint) {
            this.id = id;
            this.gameId = gameId;
            this.modId = modId;
            this.isAvailable = isAvailable;
            this.displayName = displayName;
            this.fileName = fileName;
            this.releaseType = releaseType;
            this.fileStatus = fileStatus;
            this.hashes = hashes;
            this.fileDate = fileDate;
            this.fileLength = fileLength;
            this.downloadCount = downloadCount;
            this.downloadUrl = downloadUrl;
            this.gameVersions = gameVersions;
            this.dependencies = dependencies;
            this.alternateFileId = alternateFileId;
            this.isServerPack = isServerPack;
            this.fileFingerprint = fileFingerprint;
        }

        public int getId() {
            return this.id;
        }

        public int getGameId() {
            return this.gameId;
        }

        public int getModId() {
            return this.modId;
        }

        public boolean isAvailable() {
            return this.isAvailable;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getReleaseType() {
            return this.releaseType;
        }

        public int getFileStatus() {
            return this.fileStatus;
        }

        public List<LatestFileHash> getHashes() {
            return this.hashes;
        }

        public Instant getFileDate() {
            return this.fileDate;
        }

        public int getFileLength() {
            return this.fileLength;
        }

        public int getDownloadCount() {
            return this.downloadCount;
        }

        public String getDownloadUrl() {
            if (this.downloadUrl == null) {
                return String.format("https://edge.forgecdn.net/files/%d/%d/%s", this.id / 1000, this.id % 1000, this.fileName);
            }
            return this.downloadUrl;
        }

        public List<String> getGameVersions() {
            return this.gameVersions;
        }

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        public int getAlternateFileId() {
            return this.alternateFileId;
        }

        public boolean isServerPack() {
            return this.isServerPack;
        }

        public long getFileFingerprint() {
            return this.fileFingerprint;
        }

        @Override
        public RemoteMod.Type getType() {
            return RemoteMod.Type.CURSEFORGE;
        }

        public RemoteMod.Version toVersion() {
            RemoteMod.VersionType versionType;
            switch (this.getReleaseType()) {
                case 1: {
                    versionType = RemoteMod.VersionType.Release;
                    break;
                }
                case 2: {
                    versionType = RemoteMod.VersionType.Beta;
                    break;
                }
                case 3: {
                    versionType = RemoteMod.VersionType.Alpha;
                    break;
                }
                default: {
                    versionType = RemoteMod.VersionType.Release;
                }
            }
            return new RemoteMod.Version(this, Integer.toString(this.modId), this.getDisplayName(), this.getFileName(), null, this.getFileDate(), versionType, new RemoteMod.File(Collections.emptyMap(), this.getDownloadUrl(), this.getFileName()), this.dependencies.stream().map(dependency -> {
                if (!RELATION_TYPE.containsKey(dependency.getRelationType())) {
                    throw new IllegalStateException("Broken datas.");
                }
                return RemoteMod.Dependency.ofGeneral(RELATION_TYPE.get(dependency.getRelationType()), CurseForgeRemoteModRepository.MODS, Integer.toString(dependency.getModId()));
            }).distinct().filter(Objects::nonNull).collect(Collectors.toList()), this.gameVersions.stream().filter(ver -> ver.startsWith("1.") || ver.contains("w")).collect(Collectors.toList()), this.gameVersions.stream().flatMap(version -> {
                if ("fabric".equalsIgnoreCase((String)version)) {
                    return Stream.of(ModLoaderType.FABRIC);
                }
                if ("forge".equalsIgnoreCase((String)version)) {
                    return Stream.of(ModLoaderType.FORGE);
                }
                if ("quilt".equalsIgnoreCase((String)version)) {
                    return Stream.of(ModLoaderType.QUILT);
                }
                if ("neoforge".equalsIgnoreCase((String)version)) {
                    return Stream.of(ModLoaderType.NEO_FORGED);
                }
                return Stream.empty();
            }).collect(Collectors.toList()));
        }
    }

    @Immutable
    public static class LatestFileIndex {
        private final String gameVersion;
        private final int fileId;
        private final String filename;
        private final int releaseType;
        private final int gameVersionTypeId;
        private final int modLoader;

        public LatestFileIndex(String gameVersion, int fileId, String filename, int releaseType, int gameVersionTypeId, int modLoader) {
            this.gameVersion = gameVersion;
            this.fileId = fileId;
            this.filename = filename;
            this.releaseType = releaseType;
            this.gameVersionTypeId = gameVersionTypeId;
            this.modLoader = modLoader;
        }

        public String getGameVersion() {
            return this.gameVersion;
        }

        public int getFileId() {
            return this.fileId;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getReleaseType() {
            return this.releaseType;
        }

        @Nullable
        public int getGameVersionTypeId() {
            return this.gameVersionTypeId;
        }

        public int getModLoader() {
            return this.modLoader;
        }
    }

    @Immutable
    public static class LatestFileHash {
        private final String value;
        private final int algo;

        public LatestFileHash(String value, int algo) {
            this.value = value;
            this.algo = algo;
        }

        public String getValue() {
            return this.value;
        }

        public int getAlgo() {
            return this.algo;
        }
    }

    @Immutable
    public static class Attachment {
        private final int id;
        private final int projectId;
        private final String description;
        private final boolean isDefault;
        private final String thumbnailUrl;
        private final String title;
        private final String url;
        private final int status;

        public Attachment(int id, int projectId, String description, boolean isDefault, String thumbnailUrl, String title, String url, int status) {
            this.id = id;
            this.projectId = projectId;
            this.description = description;
            this.isDefault = isDefault;
            this.thumbnailUrl = thumbnailUrl;
            this.title = title;
            this.url = url;
            this.status = status;
        }

        public int getId() {
            return this.id;
        }

        public int getProjectId() {
            return this.projectId;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public String getThumbnailUrl() {
            return this.thumbnailUrl;
        }

        public String getTitle() {
            return this.title;
        }

        public String getUrl() {
            return this.url;
        }

        public int getStatus() {
            return this.status;
        }
    }

    @Immutable
    public static class Author {
        private final int id;
        private final String name;
        private final String url;

        public Author(int id, String name, String url) {
            this.id = id;
            this.name = name;
            this.url = url;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

