/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.io.FileUtils;

public class ModpackUpdateTask
extends Task<Void> {
    private final DefaultGameRepository repository;
    private final String id;
    private final Task<?> updateTask;
    private final Path backupFolder;

    public ModpackUpdateTask(DefaultGameRepository repository, String id, Task<?> updateTask) {
        int num;
        this.repository = repository;
        this.id = id;
        this.updateTask = updateTask;
        Path backup = repository.getBaseDirectory().toPath().resolve("backup");
        do {
            num = (int)(Math.random() * 1.0E7);
        } while (Files.exists(backup.resolve(id + "-" + num), new LinkOption[0]));
        this.backupFolder = backup.resolve(id + "-" + num);
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return Collections.singleton(this.updateTask);
    }

    @Override
    public void execute() throws Exception {
        FileUtils.copyDirectory(this.repository.getVersionRoot(this.id).toPath(), this.backupFolder);
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        if (!this.isDependenciesSucceeded()) {
            this.repository.removeVersionFromDisk(this.id);
            FileUtils.copyDirectory(this.backupFolder, this.repository.getVersionRoot(this.id).toPath());
            this.repository.refreshVersionsAsync().start();
        }
    }
}

