/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.modinfo.PackMcMeta;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.Unzipper;
import org.jackhuang.hmcl.util.logging.Logger;

public class Datapack {
    private boolean isMultiple;
    private final Path path;
    private final ObservableList<Pack> info = FXCollections.observableArrayList();
    private static final String DISABLED_EXT = "disabled";

    public Datapack(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public ObservableList<Pack> getInfo() {
        return this.info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void installTo(Path worldPath) throws IOException {
        Path datapacks = worldPath.resolve("datapacks");
        HashSet<String> packs = new HashSet<String>();
        for (Object pack : this.info) {
            packs.add(((Pack)pack).getId());
        }
        if (Files.isDirectory(datapacks, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(datapacks);){
                for (Path datapack : directoryStream) {
                    if (Files.isDirectory(datapack, new LinkOption[0]) && packs.contains(FileUtils.getName(datapack))) {
                        FileUtils.deleteDirectory(datapack.toFile());
                        continue;
                    }
                    if (!Files.isRegularFile(datapack, new LinkOption[0]) || !packs.contains(FileUtils.getNameWithoutExtension(datapack))) continue;
                    Files.delete(datapack);
                }
            }
        }
        if (this.isMultiple) {
            new Unzipper(this.path, worldPath).setReplaceExistentFile(true).setFilter(new Unzipper.FileFilter(){

                @Override
                public boolean accept(Path destPath, boolean isDirectory, Path zipEntry, String entryPath) {
                    return !entryPath.equals("resources.zip");
                }
            }).unzip();
            try (FileSystem dest = CompressingUtils.createWritableZipFileSystem(worldPath.resolve("resources.zip"));
                 FileSystem zip = CompressingUtils.createReadOnlyZipFileSystem(this.path);){
                Path resourcesZip = zip.getPath("resources.zip", new String[0]);
                if (Files.isRegularFile(resourcesZip, new LinkOption[0])) {
                    Path temp = Files.createTempFile("hmcl", ".zip", new FileAttribute[0]);
                    Files.copy(resourcesZip, temp, StandardCopyOption.REPLACE_EXISTING);
                    try (FileSystem resources = CompressingUtils.createReadOnlyZipFileSystem(temp);){
                        FileUtils.copyDirectory(resources.getPath("/", new String[0]), dest.getPath("/", new String[0]));
                    }
                }
                Path packMcMeta = dest.getPath("pack.mcmeta", new String[0]);
                Files.write(packMcMeta, Arrays.asList("{", "\t\"pack\": {", "\t\t\"pack_format\": 4,", "\t\t\"description\": \"Modified by HMCL.\"", "\t}", "}"), StandardOpenOption.CREATE);
                Path packPng = dest.getPath("pack.png", new String[0]);
                if (!Files.isRegularFile(packPng, new LinkOption[0])) return;
                Files.delete(packPng);
                return;
            }
        }
        FileUtils.copyFile(this.path.toFile(), datapacks.resolve(FileUtils.getName(this.path)).toFile());
    }

    public void deletePack(Pack pack) throws IOException {
        Path subPath = pack.file;
        if (Files.isDirectory(subPath, new LinkOption[0])) {
            FileUtils.deleteDirectory(subPath.toFile());
        } else if (Files.isRegularFile(subPath, new LinkOption[0])) {
            Files.delete(subPath);
        }
        Platform.runLater(() -> this.info.removeIf(p -> p.getId().equals(pack.getId())));
    }

    public void loadFromZip() throws IOException {
        block10: {
            try (FileSystem fs = CompressingUtils.readonly(this.path).setAutoDetectEncoding(true).build();){
                Path datapacks = fs.getPath("/datapacks/", new String[0]);
                Path mcmeta = fs.getPath("pack.mcmeta", new String[0]);
                if (Files.exists(datapacks, new LinkOption[0])) {
                    this.isMultiple = true;
                    this.loadFromDir(datapacks);
                    break block10;
                }
                if (Files.exists(mcmeta, new LinkOption[0])) {
                    this.isMultiple = false;
                    try {
                        PackMcMeta pack = JsonUtils.fromNonNullJson(FileUtils.readText(mcmeta), PackMcMeta.class);
                        Platform.runLater(() -> this.info.add((Object)new Pack(this.path, FileUtils.getNameWithoutExtension(this.path), pack.getPackInfo().getDescription(), this)));
                    }
                    catch (JsonParseException | IOException e) {
                        Logger.LOG.warning("Failed to read datapack " + this.path, e);
                    }
                    break block10;
                }
                throw new IOException("Malformed datapack zip");
            }
        }
    }

    public void loadFromDir() {
        try {
            this.loadFromDir(this.path);
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to read datapacks " + this.path, e);
        }
    }

    private void loadFromDir(Path dir) throws IOException {
        ArrayList<Pack> info = new ArrayList<Pack>();
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
                for (Path subDir : directoryStream) {
                    PackMcMeta pack;
                    if (Files.isDirectory(subDir, new LinkOption[0])) {
                        Path mcmeta = subDir.resolve("pack.mcmeta");
                        Path mcmetaDisabled = subDir.resolve("pack.mcmeta.disabled");
                        if (!Files.exists(mcmeta, new LinkOption[0]) && !Files.exists(mcmetaDisabled, new LinkOption[0])) continue;
                        boolean enabled = Files.exists(mcmeta, new LinkOption[0]);
                        try {
                            pack = enabled ? JsonUtils.fromNonNullJson(FileUtils.readText(mcmeta), PackMcMeta.class) : JsonUtils.fromNonNullJson(FileUtils.readText(mcmetaDisabled), PackMcMeta.class);
                            info.add(new Pack(enabled ? mcmeta : mcmetaDisabled, FileUtils.getName(subDir), pack.getPackInfo().getDescription(), this));
                        }
                        catch (JsonParseException | IOException e) {
                            Logger.LOG.warning("Failed to read datapack " + subDir, e);
                        }
                        continue;
                    }
                    if (!Files.isRegularFile(subDir, new LinkOption[0])) continue;
                    try {
                        FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(subDir);
                        try {
                            Path mcmeta = fs.getPath("pack.mcmeta", new String[0]);
                            if (!Files.exists(mcmeta, new LinkOption[0])) continue;
                            String name = FileUtils.getName(subDir);
                            if (name.endsWith(".disabled")) {
                                name = name.substring(0, name.length() - ".disabled".length());
                            }
                            if (!name.endsWith(".zip")) continue;
                            name = StringUtils.substringBeforeLast(name, ".zip");
                            pack = JsonUtils.fromNonNullJson(FileUtils.readText(mcmeta), PackMcMeta.class);
                            info.add(new Pack(subDir, name, pack.getPackInfo().getDescription(), this));
                        }
                        finally {
                            if (fs == null) continue;
                            fs.close();
                        }
                    }
                    catch (JsonParseException | IOException e) {
                        Logger.LOG.warning("Failed to read datapack " + subDir, e);
                    }
                }
            }
        }
        Platform.runLater(() -> this.info.setAll((Collection)info));
    }

    public static class Pack {
        private Path file;
        private final BooleanProperty active;
        private final String id;
        private final LocalModFile.Description description;
        private final Datapack datapack;

        public Pack(Path file, String id, LocalModFile.Description description, Datapack datapack) {
            this.file = file;
            this.id = id;
            this.description = description;
            this.datapack = datapack;
            this.active = new SimpleBooleanProperty(this, "active", !Datapack.DISABLED_EXT.equals(FileUtils.getExtension(file))){

                protected void invalidated() {
                    Path f = file.toAbsolutePath();
                    Path newF = Datapack.DISABLED_EXT.equals(FileUtils.getExtension(f)) ? f.getParent().resolve(FileUtils.getNameWithoutExtension(f)) : f.getParent().resolve(FileUtils.getName(f) + "." + Datapack.DISABLED_EXT);
                    try {
                        Files.move(f, newF, new CopyOption[0]);
                        file = newF;
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Unable to rename file " + f + " to " + newF);
                    }
                }
            };
        }

        public String getId() {
            return this.id;
        }

        public LocalModFile.Description getDescription() {
            return this.description;
        }

        public Datapack getDatapack() {
            return this.datapack;
        }

        public BooleanProperty activeProperty() {
            return this.active;
        }

        public boolean isActive() {
            return this.active.get();
        }

        public void setActive(boolean active) {
            this.active.set(active);
        }
    }
}

