/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.jackhuang.hmcl.java.JavaInfo;
import org.jackhuang.hmcl.java.JavaLocalFiles;
import org.jackhuang.hmcl.java.JavaManifest;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Hex;
import org.jackhuang.hmcl.util.tree.ArchiveFileTree;

public final class JavaInstallTask
extends Task<JavaManifest> {
    private final Path targetDir;
    private final Map<String, Object> update;
    private final Path archiveFile;
    private final Map<String, JavaLocalFiles.Local> files = new LinkedHashMap<String, JavaLocalFiles.Local>();
    private final ArrayList<String> nameStack = new ArrayList();
    private final byte[] buffer = new byte[8192];
    private final MessageDigest messageDigest = DigestUtils.getDigest("SHA-1");

    public JavaInstallTask(Path targetDir, Map<String, Object> update, Path archiveFile) {
        this.targetDir = targetDir;
        this.update = update;
        this.archiveFile = archiveFile;
    }

    @Override
    public void execute() throws Exception {
        JavaInfo info;
        try (ArchiveFileTree<?, ?> tree = ArchiveFileTree.open(this.archiveFile);){
            info = JavaInfo.fromArchive(tree);
            this.copyDirContent(tree, this.targetDir);
        }
        this.setResult(new JavaManifest(info, this.update, this.files));
    }

    private <F, E extends ArchiveEntry> void copyDirContent(ArchiveFileTree<F, E> tree, Path targetDir) throws IOException {
        this.copyDirContent(tree, tree.getRoot().getSubDirs().values().iterator().next(), targetDir);
    }

    private <F, E extends ArchiveEntry> void copyDirContent(ArchiveFileTree<F, E> tree, ArchiveFileTree.Dir<E> dir, Path targetDir) throws IOException {
        Files.createDirectories(targetDir, new FileAttribute[0]);
        for (Map.Entry<String, E> entry : dir.getFiles().entrySet()) {
            Path path = targetDir.resolve(entry.getKey());
            ArchiveEntry entry2 = (ArchiveEntry)entry.getValue();
            this.nameStack.add(entry.getKey());
            if (tree.isLink(entry2)) {
                String linkTarget = tree.getLink(entry2);
                this.files.put(String.join((CharSequence)"/", this.nameStack), new JavaLocalFiles.LocalLink(linkTarget));
                Files.createSymbolicLink(path, Paths.get(linkTarget, new String[0]), new FileAttribute[0]);
            } else {
                long size = 0L;
                try (InputStream input = tree.getInputStream(entry2);
                     OutputStream output = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    int c;
                    this.messageDigest.reset();
                    while ((c = input.read(this.buffer)) > 0) {
                        size += (long)c;
                        output.write(this.buffer, 0, c);
                        this.messageDigest.update(this.buffer, 0, c);
                    }
                }
                if (tree.isExecutable(entry2)) {
                    path.toFile().setExecutable(true);
                }
                this.files.put(String.join((CharSequence)"/", this.nameStack), new JavaLocalFiles.LocalFile(Hex.encodeHex(this.messageDigest.digest()), size));
            }
            this.nameStack.remove(this.nameStack.size() - 1);
        }
        for (Map.Entry<String, Object> entry : dir.getSubDirs().entrySet()) {
            this.nameStack.add(entry.getKey());
            this.files.put(String.join((CharSequence)"/", this.nameStack), new JavaLocalFiles.LocalDirectory());
            this.copyDirContent(tree, (ArchiveFileTree.Dir)entry.getValue(), targetDir.resolve(entry.getKey()));
            this.nameStack.remove(this.nameStack.size() - 1);
        }
    }
}

