/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.jackhuang.hmcl.util.KeyValuePairProperties;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.tree.ArchiveFileTree;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jetbrains.annotations.Nullable;

public final class JavaInfo {
    private static final String OS_ARCH = "os.arch = ";
    private static final String JAVA_VERSION = "java.version = ";
    private static final String JAVA_VENDOR = "java.vendor = ";
    private static final String VERSION_PREFIX = "version \"";
    public static final JavaInfo CURRENT_ENVIRONMENT = new JavaInfo(Platform.CURRENT_PLATFORM, System.getProperty("java.version"), System.getProperty("java.vendor"));
    private final Platform platform;
    private final String version;
    @Nullable
    private final String vendor;
    private final transient int parsedVersion;
    private final transient VersionNumber versionNumber;

    public static int parseVersion(String version) {
        try {
            int idx = version.indexOf(46);
            if (idx < 0) {
                idx = version.indexOf(117);
                return idx > 0 ? Integer.parseInt(version.substring(0, idx)) : Integer.parseInt(version);
            }
            int major = Integer.parseInt(version.substring(0, idx));
            if (major != 1) {
                return major;
            }
            int idx2 = version.indexOf(46, idx + 1);
            if (idx2 < 0) {
                return -1;
            }
            return Integer.parseInt(version.substring(idx + 1, idx2));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static JavaInfo fromReleaseFile(BufferedReader reader) throws IOException {
        KeyValuePairProperties properties = KeyValuePairProperties.load(reader);
        String osName = (String)properties.get("OS_NAME");
        String osArch = (String)properties.get("OS_ARCH");
        String vendor = (String)properties.get("IMPLEMENTOR");
        OperatingSystem os = "".equals(osName) && "OpenJDK BSD Porting Team".equals(vendor) ? OperatingSystem.FREEBSD : OperatingSystem.parseOSName(osName);
        Architecture arch = Architecture.parseArchName(osArch);
        String javaVersion = (String)properties.get("JAVA_VERSION");
        if (os == OperatingSystem.UNKNOWN) {
            throw new IOException("Unknown operating system: " + osName);
        }
        if (arch == Architecture.UNKNOWN) {
            throw new IOException("Unknown architecture: " + osArch);
        }
        if (javaVersion == null) {
            throw new IOException("Missing Java version");
        }
        return new JavaInfo(Platform.getPlatform(os, arch), javaVersion, vendor);
    }

    public static JavaInfo fromReleaseFile(Path releaseFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(releaseFile);){
            JavaInfo javaInfo = JavaInfo.fromReleaseFile(reader);
            return javaInfo;
        }
    }

    public static <F, E extends ArchiveEntry> JavaInfo fromArchive(ArchiveFileTree<F, E> tree) throws IOException {
        JavaInfo info;
        if (tree.getRoot().getSubDirs().size() != 1 || !tree.getRoot().getFiles().isEmpty()) {
            throw new IOException();
        }
        ArchiveFileTree.Dir<E> jdkRoot = tree.getRoot().getSubDirs().values().iterator().next();
        ArchiveEntry releaseEntry = (ArchiveEntry)jdkRoot.getFiles().get("release");
        if (releaseEntry == null) {
            throw new IOException("Missing release file");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(tree.getInputStream(releaseEntry), StandardCharsets.UTF_8));){
            info = JavaInfo.fromReleaseFile(reader);
        }
        ArchiveFileTree.Dir<E> binDir = jdkRoot.getSubDirs().get("bin");
        if (binDir == null || binDir.getFiles().get(info.getPlatform().getOperatingSystem().getJavaExecutable()) == null) {
            throw new IOException("Missing java executable file");
        }
        return info;
    }

    public static String normalizeVendor(String vendor) {
        if (vendor == null) {
            return null;
        }
        switch (vendor) {
            case "N/A": {
                return null;
            }
            case "Oracle Corporation": {
                return "Oracle";
            }
            case "Azul Systems, Inc.": {
                return "Azul";
            }
            case "IBM Corporation": 
            case "International Business Machines Corporation": 
            case "Eclipse OpenJ9": {
                return "IBM";
            }
            case "Eclipse Adoptium": {
                return "Adoptium";
            }
            case "Amazon.com Inc.": {
                return "Amazon";
            }
        }
        return vendor;
    }

    public static JavaInfo fromExecutable(Path executable) throws IOException {
        return JavaInfo.fromExecutable(executable, true);
    }

    public static JavaInfo fromExecutable(Path executable, boolean tryFindReleaseFile) throws IOException {
        Path javaHome;
        assert (executable.isAbsolute());
        Path parent = executable.getParent();
        if (tryFindReleaseFile && parent != null && parent.getFileName() != null && parent.getFileName().toString().equals("bin") && (javaHome = parent.getParent()) != null && javaHome.getFileName() != null) {
            Path releaseFile = javaHome.resolve("release");
            String javaHomeName = javaHome.getFileName().toString();
            if ((javaHomeName.contains("jre") || javaHomeName.contains("jdk") || javaHomeName.contains("openj9")) && Files.isRegularFile(releaseFile, new LinkOption[0])) {
                try {
                    return JavaInfo.fromReleaseFile(releaseFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        String osArch = null;
        String version = null;
        String vendor = null;
        Platform platform = null;
        String executablePath = executable.toString();
        Process process = new ProcessBuilder(executablePath, "-XshowSettings:properties", "-version").start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), OperatingSystem.NATIVE_CHARSET));){
            String line;
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf(OS_ARCH);
                if (idx >= 0) {
                    osArch = line.substring(idx + OS_ARCH.length()).trim();
                    if (version == null || vendor == null) continue;
                } else {
                    idx = line.indexOf(JAVA_VERSION);
                    if (idx >= 0) {
                        version = line.substring(idx + JAVA_VERSION.length()).trim();
                        if (osArch == null || vendor == null) continue;
                    } else {
                        idx = line.indexOf(JAVA_VENDOR);
                        if (idx < 0) continue;
                        vendor = line.substring(idx + JAVA_VENDOR.length()).trim();
                        if (osArch == null || version == null) continue;
                    }
                }
                break;
            }
        }
        if (osArch != null) {
            platform = Platform.getPlatform(OperatingSystem.CURRENT_OS, Architecture.parseArchName(osArch));
        }
        if (version == null) {
            boolean is64Bit = false;
            process = new ProcessBuilder(executablePath, "-version").start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), OperatingSystem.NATIVE_CHARSET));){
                String line;
                while ((line = reader.readLine()) != null) {
                    int begin;
                    int end;
                    int idx;
                    if (version == null && (idx = line.indexOf(VERSION_PREFIX)) >= 0 && (end = line.indexOf(34, begin = idx + VERSION_PREFIX.length())) >= 0) {
                        version = line.substring(begin, end);
                    }
                    if (!line.contains("64-Bit")) continue;
                    is64Bit = true;
                }
            }
            if (platform == null) {
                platform = Platform.getPlatform(OperatingSystem.CURRENT_OS, is64Bit ? Architecture.X86_64 : Architecture.X86);
            }
            if (version == null) {
                throw new IOException("Cannot determine version");
            }
        }
        return new JavaInfo(platform, version, vendor);
    }

    public JavaInfo(Platform platform, String version, @Nullable String vendor) {
        this.platform = platform;
        this.version = version;
        this.parsedVersion = JavaInfo.parseVersion(version);
        this.versionNumber = VersionNumber.asVersion(version);
        this.vendor = vendor;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    public VersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    public int getParsedVersion() {
        return this.parsedVersion;
    }

    @Nullable
    public String getVendor() {
        return this.vendor;
    }

    public String toString() {
        return JsonUtils.GSON.toJson(this);
    }
}

