/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.image.Image;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventManager;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.GameDirectoryType;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.mod.ModAdviser;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackProvider;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.ProxyManager;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.javafx.PropertyUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jetbrains.annotations.Nullable;

public class HMCLGameRepository
extends DefaultGameRepository {
    private final Profile profile;
    private final Map<String, VersionSetting> localVersionSettings = new HashMap<String, VersionSetting>();
    private final Set<String> beingModpackVersions = new HashSet<String>();
    public final EventManager<Event> onVersionIconChanged = new EventManager();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String PROFILE = "{\"selectedProfile\": \"(Default)\",\"profiles\": {\"(Default)\": {\"name\": \"(Default)\"}},\"clientToken\": \"88888888-8888-8888-8888-888888888888\"}";
    private static final Set<String> FORBIDDEN_VERSION_IDS = new HashSet<String>(Arrays.asList("modpack", "minecraftinstance", "manifest"));

    public HMCLGameRepository(Profile profile, File baseDirectory) {
        super(baseDirectory);
        this.profile = profile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public GameDirectoryType getGameDirectoryType(String id) {
        if (this.beingModpackVersions.contains(id) || this.isModpack(id)) {
            return GameDirectoryType.VERSION_FOLDER;
        }
        return this.getVersionSetting(id).getGameDirType();
    }

    @Override
    public File getRunDirectory(String id) {
        switch (this.getGameDirectoryType(id)) {
            case VERSION_FOLDER: {
                return this.getVersionRoot(id);
            }
            case ROOT_FOLDER: {
                return super.getRunDirectory(id);
            }
            case CUSTOM: {
                File dir = new File(this.getVersionSetting(id).getGameDir());
                if (!FileUtils.isValidPath(dir)) {
                    return this.getVersionRoot(id);
                }
                return dir;
            }
        }
        throw new Error();
    }

    public Stream<Version> getDisplayVersions() {
        return this.getVersions().stream().filter(v -> !v.isHidden()).sorted(Comparator.comparing(v -> Lang.requireNonNullElse(v.getReleaseTime(), Instant.EPOCH)).thenComparing(v -> VersionNumber.asVersion(v.getId())));
    }

    @Override
    protected void refreshVersionsImpl() {
        this.localVersionSettings.clear();
        super.refreshVersionsImpl();
        this.versions.keySet().forEach(this::loadLocalVersionSetting);
        this.versions.keySet().forEach(version -> {
            if (this.isModpack((String)version)) {
                this.specializeVersionSetting((String)version);
            }
        });
        try {
            File file = new File(this.getBaseDirectory(), "launcher_profiles.json");
            if (!file.exists() && !this.versions.isEmpty()) {
                FileUtils.writeText(file, PROFILE);
            }
        }
        catch (IOException ex) {
            Logger.LOG.warning("Unable to create launcher_profiles.json, Forge/LiteLoader installer will not work.", ex);
        }
        System.gc();
    }

    public void changeDirectory(File newDirectory) {
        this.setBaseDirectory(newDirectory);
        this.refreshVersionsAsync().start();
    }

    private void clean(File directory) throws IOException {
        FileUtils.deleteDirectory(new File(directory, "crash-reports"));
        FileUtils.deleteDirectory(new File(directory, "logs"));
    }

    public void clean(String id) throws IOException {
        this.clean(this.getBaseDirectory());
        this.clean(this.getRunDirectory(id));
    }

    public void duplicateVersion(String srcId, String dstId, boolean copySaves) throws IOException {
        Path srcDir = this.getVersionRoot(srcId).toPath();
        Path dstDir = this.getVersionRoot(dstId).toPath();
        Version fromVersion = this.getVersion(srcId);
        if (Files.exists(dstDir, new LinkOption[0])) {
            throw new IOException("Version exists");
        }
        FileUtils.copyDirectory(srcDir, dstDir);
        Path fromJson = dstDir.resolve(srcId + ".json");
        Path fromJar = dstDir.resolve(srcId + ".jar");
        Path toJson = dstDir.resolve(dstId + ".json");
        Path toJar = dstDir.resolve(dstId + ".jar");
        if (Files.exists(fromJar, new LinkOption[0])) {
            Files.move(fromJar, toJar, new CopyOption[0]);
        }
        Files.move(fromJson, toJson, new CopyOption[0]);
        FileUtils.writeText(toJson.toFile(), JsonUtils.GSON.toJson(fromVersion.setId(dstId)));
        VersionSetting oldVersionSetting = this.getVersionSetting(srcId).clone();
        GameDirectoryType originalGameDirType = oldVersionSetting.getGameDirType();
        oldVersionSetting.setUsesGlobal(false);
        oldVersionSetting.setGameDirType(GameDirectoryType.VERSION_FOLDER);
        VersionSetting newVersionSetting = this.initLocalVersionSetting(dstId, oldVersionSetting);
        this.saveVersionSetting(dstId);
        File srcGameDir = this.getRunDirectory(srcId);
        File dstGameDir = this.getRunDirectory(dstId);
        ArrayList<String> blackList = new ArrayList<String>(ModAdviser.MODPACK_BLACK_LIST);
        blackList.add(srcId + ".jar");
        blackList.add(srcId + ".json");
        if (!copySaves) {
            blackList.add("saves");
        }
        if (originalGameDirType != GameDirectoryType.VERSION_FOLDER) {
            FileUtils.copyDirectory(srcGameDir.toPath(), dstGameDir.toPath(), path -> Modpack.acceptFile(path, blackList, null));
        }
    }

    private File getLocalVersionSettingFile(String id) {
        return new File(this.getVersionRoot(id), "hmclversion.cfg");
    }

    private void loadLocalVersionSetting(String id) {
        File file = this.getLocalVersionSettingFile(id);
        if (file.exists()) {
            try {
                VersionSetting versionSetting = GSON.fromJson(FileUtils.readText(file), VersionSetting.class);
                this.initLocalVersionSetting(id, versionSetting);
            }
            catch (Exception ex) {
                this.initLocalVersionSetting(id, new VersionSetting());
            }
        }
    }

    public VersionSetting createLocalVersionSetting(String id) {
        if (!this.hasVersion(id)) {
            return null;
        }
        if (this.localVersionSettings.containsKey(id)) {
            return this.getLocalVersionSetting(id);
        }
        return this.initLocalVersionSetting(id, new VersionSetting());
    }

    private VersionSetting initLocalVersionSetting(String id, VersionSetting vs) {
        this.localVersionSettings.put(id, vs);
        vs.addListener(a -> this.saveVersionSetting(id));
        return vs;
    }

    @Nullable
    public VersionSetting getLocalVersionSetting(String id) {
        VersionSetting setting;
        if (!this.localVersionSettings.containsKey(id)) {
            this.loadLocalVersionSetting(id);
        }
        if ((setting = this.localVersionSettings.get(id)) != null && this.isModpack(id)) {
            setting.setGameDirType(GameDirectoryType.VERSION_FOLDER);
        }
        return setting;
    }

    @Nullable
    public VersionSetting getLocalVersionSettingOrCreate(String id) {
        VersionSetting vs = this.getLocalVersionSetting(id);
        if (vs == null) {
            vs = this.createLocalVersionSetting(id);
        }
        return vs;
    }

    public VersionSetting getVersionSetting(String id) {
        VersionSetting vs = this.getLocalVersionSetting(id);
        if (vs == null || vs.isUsesGlobal()) {
            this.profile.getGlobal().setUsesGlobal(true);
            return this.profile.getGlobal();
        }
        return vs;
    }

    public Optional<File> getVersionIconFile(String id) {
        File root = this.getVersionRoot(id);
        for (String extension : FXUtils.IMAGE_EXTENSIONS) {
            File file = new File(root, "icon." + extension);
            if (!file.exists()) continue;
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public void setVersionIconFile(String id, File iconFile) throws IOException {
        String ext = FileUtils.getExtension(iconFile).toLowerCase(Locale.ROOT);
        if (!FXUtils.IMAGE_EXTENSIONS.contains(ext)) {
            throw new IllegalArgumentException("Unsupported icon file: " + ext);
        }
        this.deleteIconFile(id);
        FileUtils.copyFile(iconFile, new File(this.getVersionRoot(id), "icon." + ext));
    }

    public void deleteIconFile(String id) {
        File root = this.getVersionRoot(id);
        for (String extension : FXUtils.IMAGE_EXTENSIONS) {
            new File(root, "icon." + extension).delete();
        }
    }

    public Image getVersionIconImage(String id) {
        VersionIconType iconType;
        if (id == null || !this.isLoaded()) {
            return VersionIconType.DEFAULT.getIcon();
        }
        VersionSetting vs = this.getLocalVersionSettingOrCreate(id);
        VersionIconType versionIconType = iconType = vs != null ? Lang.requireNonNullElse(vs.getVersionIcon(), VersionIconType.DEFAULT) : VersionIconType.DEFAULT;
        if (iconType == VersionIconType.DEFAULT) {
            Version version = this.getVersion(id).resolve(this);
            Optional<File> iconFile = this.getVersionIconFile(id);
            if (iconFile.isPresent()) {
                try {
                    return FXUtils.loadImage(iconFile.get().toPath());
                }
                catch (Exception e) {
                    Logger.LOG.warning("Failed to load version icon of " + id, e);
                }
            }
            if (LibraryAnalyzer.isModded(this, version)) {
                LibraryAnalyzer libraryAnalyzer = LibraryAnalyzer.analyze(version, null);
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FABRIC)) {
                    return VersionIconType.FABRIC.getIcon();
                }
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FORGE)) {
                    return VersionIconType.FORGE.getIcon();
                }
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.NEO_FORGE)) {
                    return VersionIconType.NEO_FORGE.getIcon();
                }
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.QUILT)) {
                    return VersionIconType.QUILT.getIcon();
                }
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.OPTIFINE)) {
                    return VersionIconType.OPTIFINE.getIcon();
                }
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.LITELOADER)) {
                    return VersionIconType.CHICKEN.getIcon();
                }
                return VersionIconType.FURNACE.getIcon();
            }
            return VersionIconType.DEFAULT.getIcon();
        }
        return iconType.getIcon();
    }

    public boolean saveVersionSetting(String id) {
        if (!this.localVersionSettings.containsKey(id)) {
            return false;
        }
        File file = this.getLocalVersionSettingFile(id);
        if (!FileUtils.makeDirectory(file.getAbsoluteFile().getParentFile())) {
            return false;
        }
        Logger.LOG.info("Saving version setting: " + id);
        try {
            FileUtils.writeText(file, GSON.toJson(this.localVersionSettings.get(id)));
            return true;
        }
        catch (IOException e) {
            Logger.LOG.error("Unable to save version setting of " + id, e);
            return false;
        }
    }

    public VersionSetting specializeVersionSetting(String id) {
        VersionSetting vs = this.getLocalVersionSetting(id);
        if (vs == null) {
            vs = this.createLocalVersionSetting(id);
        }
        if (vs == null) {
            return null;
        }
        VersionIconType versionIcon = vs.getVersionIcon();
        if (vs.isUsesGlobal()) {
            PropertyUtils.copyProperties(this.profile.getGlobal(), vs);
            vs.setUsesGlobal(false);
        }
        vs.setVersionIcon(versionIcon);
        return vs;
    }

    public void globalizeVersionSetting(String id) {
        VersionSetting vs = this.getLocalVersionSetting(id);
        if (vs != null) {
            vs.setUsesGlobal(true);
        }
    }

    public LaunchOptions getLaunchOptions(String version, JavaRuntime javaVersion, File gameDir, List<String> javaAgents, boolean makeLaunchScript) {
        File json;
        VersionSetting vs = this.getVersionSetting(version);
        LaunchOptions.Builder builder = new LaunchOptions.Builder().setGameDir(gameDir).setJava(javaVersion).setVersionType(Metadata.TITLE).setVersionName(version).setProfileName(Metadata.TITLE).setGameArguments(StringUtils.tokenize(vs.getMinecraftArgs())).setOverrideJavaArguments(StringUtils.tokenize(vs.getJavaArgs())).setMaxMemory(vs.isNoJVMArgs() && vs.isAutoMemory() ? null : Integer.valueOf((int)(HMCLGameRepository.getAllocatedMemory((long)vs.getMaxMemory() * 1024L * 1024L, OperatingSystem.getPhysicalMemoryStatus().getAvailable(), vs.isAutoMemory()) / 1024L / 1024L))).setMinMemory(vs.getMinMemory()).setMetaspace(Lang.toIntOrNull(vs.getPermSize())).setEnvironmentVariables(Lang.mapOf(StringUtils.tokenize(vs.getEnvironmentVariables()).stream().map(it -> {
            int idx = it.indexOf(61);
            return idx >= 0 ? Pair.pair(it.substring(0, idx), it.substring(idx + 1)) : Pair.pair(it, "");
        }).collect(Collectors.toList()))).setWidth(vs.getWidth()).setHeight(vs.getHeight()).setFullscreen(vs.isFullscreen()).setServerIp(vs.getServerIp()).setWrapper(vs.getWrapper()).setPreLaunchCommand(vs.getPreLaunchCommand()).setPostExitCommand(vs.getPostExitCommand()).setNoGeneratedJVMArgs(vs.isNoJVMArgs()).setNativesDirType(vs.getNativesDirType()).setNativesDir(vs.getNativesDir()).setProcessPriority(vs.getProcessPriority()).setRenderer(vs.getRenderer()).setUseNativeGLFW(vs.isUseNativeGLFW()).setUseNativeOpenAL(vs.isUseNativeOpenAL()).setDaemon(!makeLaunchScript && vs.getLauncherVisibility().isDaemon()).setJavaAgents(javaAgents);
        if (ConfigHolder.config().hasProxy()) {
            builder.setProxy(ProxyManager.getProxy());
            if (ConfigHolder.config().hasProxyAuth()) {
                builder.setProxyUser(ConfigHolder.config().getProxyUser());
                builder.setProxyPass(ConfigHolder.config().getProxyPass());
            }
        }
        if ((json = this.getModpackConfiguration(version)).exists()) {
            try {
                String jsonText = FileUtils.readText(json);
                ModpackConfiguration modpackConfiguration = JsonUtils.GSON.fromJson(jsonText, ModpackConfiguration.class);
                ModpackProvider provider = ModpackHelper.getProviderByType(modpackConfiguration.getType());
                if (provider != null) {
                    provider.injectLaunchOptions(jsonText, builder);
                }
            }
            catch (JsonParseException | IOException e) {
                e.printStackTrace();
            }
        }
        if (vs.isAutoMemory() && builder.getJavaArguments().stream().anyMatch(it -> it.startsWith("-Xmx"))) {
            builder.setMaxMemory(null);
        }
        return builder.create();
    }

    @Override
    public File getModpackConfiguration(String version) {
        return new File(this.getVersionRoot(version), "modpack.cfg");
    }

    public void markVersionAsModpack(String id) {
        this.beingModpackVersions.add(id);
    }

    public void undoMark(String id) {
        this.beingModpackVersions.remove(id);
    }

    public void markVersionLaunchedAbnormally(String id) {
        try {
            Files.createFile(this.getVersionRoot(id).toPath().resolve(".abnormal"), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean unmarkVersionLaunchedAbnormally(String id) {
        File file = new File(this.getVersionRoot(id), ".abnormal");
        boolean result = file.isFile();
        file.delete();
        return result;
    }

    public static boolean isValidVersionId(String id) {
        if (FORBIDDEN_VERSION_IDS.contains(id)) {
            return false;
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && FORBIDDEN_VERSION_IDS.contains(id.toLowerCase(Locale.ROOT))) {
            return false;
        }
        return OperatingSystem.isNameValid(id);
    }

    public boolean versionIdConflicts(String id) {
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            for (String existingId : this.versions.keySet()) {
                if (!existingId.equalsIgnoreCase(id)) continue;
                return true;
            }
            return false;
        }
        return this.versions.containsKey(id);
    }

    public static long getAllocatedMemory(long minimum, long available, boolean auto) {
        if (auto) {
            if ((available -= 0x18000000L) <= 0L) {
                return minimum;
            }
            long threshold = 0x200000000L;
            long suggested = Math.min(available <= 0x200000000L ? (long)((double)available * 0.8) : (long)(6.8719476736E9 + (double)(available - 0x200000000L) * 0.2), 0x400000000L);
            return Math.max(minimum, suggested);
        }
        return minimum;
    }
}

