/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.time.Instant;
import java.util.List;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.game.GameInstallTask;
import org.jackhuang.hmcl.game.ReleaseType;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Immutable;

@Immutable
public final class GameRemoteVersion
extends RemoteVersion {
    private final ReleaseType type;

    public GameRemoteVersion(String gameVersion, String selfVersion, List<String> url, ReleaseType type, Instant releaseDate) {
        super(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId(), gameVersion, selfVersion, releaseDate, GameRemoteVersion.getReleaseType(type), url);
        this.type = type;
    }

    public ReleaseType getType() {
        return this.type;
    }

    @Override
    public Task<Version> getInstallTask(DefaultDependencyManager dependencyManager, Version baseVersion) {
        return new GameInstallTask(dependencyManager, baseVersion, this);
    }

    @Override
    public int compareTo(RemoteVersion o) {
        if (!(o instanceof GameRemoteVersion)) {
            return 0;
        }
        return o.getReleaseDate().compareTo(this.getReleaseDate());
    }

    private static RemoteVersion.Type getReleaseType(ReleaseType type) {
        if (type == null) {
            return RemoteVersion.Type.UNCATEGORIZED;
        }
        switch (type) {
            case RELEASE: {
                return RemoteVersion.Type.RELEASE;
            }
            case SNAPSHOT: {
                return RemoteVersion.Type.SNAPSHOT;
            }
            case UNKNOWN: {
                return RemoteVersion.Type.UNCATEGORIZED;
            }
        }
        return RemoteVersion.Type.OLD;
    }
}

