/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public class RemoteVersion
implements Comparable<RemoteVersion> {
    private final String libraryId;
    private final String gameVersion;
    private final String selfVersion;
    private final Instant releaseDate;
    private final List<String> urls;
    private final Type type;

    public RemoteVersion(String libraryId, String gameVersion, String selfVersion, Instant releaseDate, List<String> urls) {
        this(libraryId, gameVersion, selfVersion, releaseDate, Type.UNCATEGORIZED, urls);
    }

    public RemoteVersion(String libraryId, String gameVersion, String selfVersion, Instant releaseDate, Type type, List<String> urls) {
        this.libraryId = Objects.requireNonNull(libraryId);
        this.gameVersion = Objects.requireNonNull(gameVersion);
        this.selfVersion = Objects.requireNonNull(selfVersion);
        this.releaseDate = releaseDate;
        this.urls = Objects.requireNonNull(urls);
        this.type = Objects.requireNonNull(type);
    }

    public String getLibraryId() {
        return this.libraryId;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public String getSelfVersion() {
        return this.selfVersion;
    }

    public String getFullVersion() {
        return this.getSelfVersion();
    }

    public Instant getReleaseDate() {
        return this.releaseDate;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public Type getVersionType() {
        return this.type;
    }

    public Task<Version> getInstallTask(DefaultDependencyManager dependencyManager, Version baseVersion) {
        throw new UnsupportedOperationException(this + " cannot be installed yet");
    }

    public boolean equals(Object obj) {
        return obj instanceof RemoteVersion && Objects.equals(this.selfVersion, ((RemoteVersion)obj).selfVersion);
    }

    public int hashCode() {
        return this.selfVersion.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("selfVersion", this.selfVersion).append("gameVersion", this.gameVersion).toString();
    }

    @Override
    public int compareTo(RemoteVersion o) {
        return VersionNumber.asVersion(o.selfVersion).compareTo(VersionNumber.asVersion(this.selfVersion));
    }

    public static enum Type {
        UNCATEGORIZED,
        RELEASE,
        SNAPSHOT,
        OLD;

    }
}

