/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.util.logging.Logger;

public class MultipleSourceVersionList
extends VersionList<RemoteVersion> {
    private final VersionList<?>[] backends;

    MultipleSourceVersionList(VersionList<?>[] backends) {
        this.backends = backends;
        assert (backends.length >= 1);
    }

    @Override
    public boolean hasType() {
        boolean hasType = this.backends[0].hasType();
        assert (Arrays.stream(this.backends).allMatch(versionList -> versionList.hasType() == hasType));
        return hasType;
    }

    @Override
    public CompletableFuture<?> loadAsync() {
        throw new UnsupportedOperationException("MultipleSourceVersionList does not support loading the entire remote version list.");
    }

    @Override
    public CompletableFuture<?> refreshAsync() {
        throw new UnsupportedOperationException("MultipleSourceVersionList does not support loading the entire remote version list.");
    }

    private CompletableFuture<?> refreshAsync(String gameVersion, int sourceIndex) {
        VersionList<?> versionList = this.backends[sourceIndex];
        CompletionStage future = versionList.refreshAsync(gameVersion).thenRunAsync(() -> {
            this.lock.writeLock().lock();
            try {
                this.versions.putAll(gameVersion, versionList.getVersions(gameVersion));
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
        if (sourceIndex == this.backends.length - 1) {
            return future;
        }
        return ((CompletableFuture)((CompletableFuture)future).handle((arg_0, arg_1) -> this.lambda$refreshAsync$2((CompletableFuture)future, gameVersion, sourceIndex, arg_0, arg_1))).thenCompose(it -> it);
    }

    @Override
    public CompletableFuture<?> refreshAsync(String gameVersion) {
        this.versions.clear(gameVersion);
        return this.refreshAsync(gameVersion, 0);
    }

    private /* synthetic */ CompletableFuture lambda$refreshAsync$2(CompletableFuture future, String gameVersion, int sourceIndex, Void ignore, Throwable e) {
        if (e == null) {
            return future;
        }
        Logger.LOG.warning("Failed to fetch versions list and try to fetch from other source", e);
        return this.refreshAsync(gameVersion, sourceIndex + 1);
    }
}

