/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public interface DownloadProvider {
    public String getVersionListURL();

    public String getAssetBaseURL();

    default public List<URL> getAssetObjectCandidates(String assetObjectLocation) {
        return Collections.singletonList(NetworkUtils.toURL(this.getAssetBaseURL() + assetObjectLocation));
    }

    public String injectURL(String var1);

    default public List<URL> injectURLWithCandidates(String baseURL) {
        return Collections.singletonList(NetworkUtils.toURL(this.injectURL(baseURL)));
    }

    default public List<URL> injectURLsWithCandidates(List<String> urls) {
        return urls.stream().flatMap(url -> this.injectURLWithCandidates((String)url).stream()).collect(Collectors.toList());
    }

    public VersionList<?> getVersionListById(String var1);

    public int getConcurrency();
}

