/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.offline;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import org.jackhuang.hmcl.util.Hex;

public final class Texture {
    private final String hash;
    private final Image image;
    private static final Map<String, Texture> textures = new HashMap<String, Texture>();

    public Texture(String hash, Image image) {
        this.hash = Objects.requireNonNull(hash);
        this.image = Objects.requireNonNull(image);
    }

    public String getHash() {
        return this.hash;
    }

    public Image getImage() {
        return this.image;
    }

    public static boolean hasTexture(String hash) {
        return textures.containsKey(hash);
    }

    public static Texture getTexture(String hash) {
        return textures.get(hash);
    }

    private static String computeTextureHash(Image img) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        PixelReader reader = img.getPixelReader();
        int width = (int)img.getWidth();
        int height = (int)img.getHeight();
        byte[] buf = new byte[4096];
        Texture.putInt(buf, 0, width);
        Texture.putInt(buf, 4, height);
        int pos = 8;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                Texture.putInt(buf, pos, reader.getArgb(x, y));
                if (buf[pos + 0] == 0) {
                    buf[pos + 3] = 0;
                    buf[pos + 2] = 0;
                    buf[pos + 1] = 0;
                }
                if ((pos += 4) != buf.length) continue;
                pos = 0;
                digest.update(buf, 0, buf.length);
            }
        }
        if (pos > 0) {
            digest.update(buf, 0, pos);
        }
        return Hex.encodeHex(digest.digest());
    }

    private static void putInt(byte[] array, int offset, int x) {
        array[offset + 0] = (byte)(x >> 24 & 0xFF);
        array[offset + 1] = (byte)(x >> 16 & 0xFF);
        array[offset + 2] = (byte)(x >> 8 & 0xFF);
        array[offset + 3] = (byte)(x >> 0 & 0xFF);
    }

    public static Texture loadTexture(InputStream in) throws IOException {
        Image img;
        if (in == null) {
            return null;
        }
        try (InputStream is = in;){
            img = new Image(is);
        }
        if (img.isError()) {
            throw new IOException("No image found", img.getException());
        }
        return Texture.loadTexture(img);
    }

    public static Texture loadTexture(Image image) {
        if (image == null) {
            return null;
        }
        String hash = Texture.computeTextureHash(image);
        Texture existent = textures.get(hash);
        if (existent != null) {
            return existent;
        }
        Texture texture = new Texture(hash, image);
        existent = textures.putIfAbsent(hash, texture);
        if (existent != null) {
            return existent;
        }
        return texture;
    }
}

